/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.block_entities.block.RiftBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class RenderRift
implements BlockEntityRenderer<RiftBlockEntity> {
    BlockEntityRenderDispatcher dispatcher;
    static final RenderType eden = RenderType.entityTranslucentCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/block/eden_rift_full.png"));
    static final RenderType wildwood = RenderType.entityTranslucentCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/block/wildwood_rift_full.png"));
    static final RenderType apalachia = RenderType.entityTranslucentCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/block/apalachia_rift_full.png"));
    static final RenderType skythern = RenderType.entityTranslucentCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/block/skythern_rift_full.png"));
    static final RenderType mortum = RenderType.entityTranslucentCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/block/mortum_rift_full.png"));
    static float sh1 = (float)Math.floor(Math.random() * 4.0) * 0.25f;
    static float sh2 = 0.125f + (float)Math.floor(Math.random() * 4.0) * 0.25f;
    static float sh3 = (float)Math.floor(Math.random() * 4.0) * 0.25f;
    static float sh4 = 0.125f + (float)Math.floor(Math.random() * 4.0) * 0.25f;

    public RenderRift(BlockEntityRendererProvider.Context context) {
        this.dispatcher = context.getBlockEntityRenderDispatcher();
    }

    public void render(RiftBlockEntity riftBlockEntity, float v, PoseStack matrix, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (riftBlockEntity.variant == 0) {
            return;
        }
        matrix.pushPose();
        matrix.translate(0.5f, 0.1f, 0.5f);
        matrix.scale(2.0f, 2.0f, 2.0f);
        matrix.mulPose(this.dispatcher.camera.rotation());
        PoseStack.Pose matrixEntry = matrix.last();
        Matrix4f matrix4f = matrixEntry.pose();
        VertexConsumer vertexBuilder = buffer.getBuffer(switch (riftBlockEntity.variant & 7) {
            case 1 -> eden;
            case 2 -> wildwood;
            case 3 -> apalachia;
            case 4 -> skythern;
            default -> mortum;
        });
        if ((riftBlockEntity.variant & 0x10) == 16) {
            switch (Mth.floor((double)(Math.random() * 5.0))) {
                case 0: {
                    sh1 = (float)Math.floor(Math.random() * 4.0) * 0.25f;
                    break;
                }
                case 1: {
                    sh2 = 0.125f + (float)Math.floor(Math.random() * 4.0) * 0.25f;
                    break;
                }
                case 2: {
                    sh3 = (float)Math.floor(Math.random() * 4.0) * 0.25f;
                    break;
                }
                case 3: {
                    sh4 = 0.125f + (float)Math.floor(Math.random() * 4.0) * 0.25f;
                    break;
                }
            }
            RenderRift.poses(vertexBuilder, matrix4f, packedLight, 0.0f, 0.5f, 0.0f, sh1);
            RenderRift.poses(vertexBuilder, matrix4f, packedLight, 0.0f, 0.0f, 0.0f, sh2);
            RenderRift.poses(vertexBuilder, matrix4f, packedLight, 0.5f, 0.5f, 0.5f, sh3);
            RenderRift.poses(vertexBuilder, matrix4f, packedLight, 0.5f, 0.0f, 0.5f, sh4);
        } else {
            float shift = (float)(riftBlockEntity.clientTickCount >> 2 & 3) * 0.25f;
            float shiftmax = shift + 0.25f;
            RenderRift.pos(vertexBuilder, matrix4f, packedLight, 0.0f, 0.0f, 0.0f, shiftmax);
            RenderRift.pos(vertexBuilder, matrix4f, packedLight, 1.0f, 0.0f, 1.0f, shiftmax);
            RenderRift.pos(vertexBuilder, matrix4f, packedLight, 1.0f, 1.0f, 1.0f, shift);
            RenderRift.pos(vertexBuilder, matrix4f, packedLight, 0.0f, 1.0f, 0.0f, shift);
        }
        matrix.popPose();
    }

    private static void poses(VertexConsumer vertexBuilder, Matrix4f matrix4f, int packedLight, float x, float y, float slide, float shift) {
        float slidemax = slide + 0.5f;
        float shiftmax = shift + 0.125f;
        float xmax = x + 0.5f;
        float ymax = y + 0.5f;
        RenderRift.pos(vertexBuilder, matrix4f, packedLight, x, y, slide, shiftmax);
        RenderRift.pos(vertexBuilder, matrix4f, packedLight, xmax, y, slidemax, shiftmax);
        RenderRift.pos(vertexBuilder, matrix4f, packedLight, xmax, ymax, slidemax, shift);
        RenderRift.pos(vertexBuilder, matrix4f, packedLight, x, ymax, slide, shift);
    }

    private static void pos(VertexConsumer vertexBuilder, Matrix4f matrix4f, int lightmapUV, float x, float y, float u, float v) {
        vertexBuilder.addVertex(matrix4f, x - 0.5f, y - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(lightmapUV).setNormal(0.0f, 1.0f, 0.0f);
    }
}

