/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.block_entities.bosses.StatueBlockEntity;
import divinerpg.blocks.base.BlockStatue;
import divinerpg.blocks.base.BlockStatueColored;
import divinerpg.client.models.boss.ModelAncientEntity;
import divinerpg.client.models.boss.ModelAyeraco;
import divinerpg.client.models.boss.ModelDensos;
import divinerpg.client.models.boss.ModelDramix;
import divinerpg.client.models.boss.ModelEternalArcher;
import divinerpg.client.models.boss.ModelExperiencedCori;
import divinerpg.client.models.boss.ModelKarot;
import divinerpg.client.models.boss.ModelKingOfScorchers;
import divinerpg.client.models.boss.ModelKitra;
import divinerpg.client.models.boss.ModelParasecta;
import divinerpg.client.models.boss.ModelSoulFiend;
import divinerpg.client.models.boss.ModelSunstorm;
import divinerpg.client.models.boss.ModelTermasect;
import divinerpg.client.models.boss.ModelTwilightDemon;
import divinerpg.client.models.boss.ModelVamacheron;
import divinerpg.client.models.vanilla.ModelWatcher;
import divinerpg.enums.BlockColor;
import divinerpg.registries.BlockRegistry;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderStatue
implements BlockEntityRenderer<StatueBlockEntity> {
    BlockEntityRendererProvider.Context context;

    public RenderStatue(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(StatueBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Model model = this.getModel(te);
        matrixStack.pushPose();
        if (te.getBlockState().is((Block)BlockRegistry.sunstormStatue.get())) {
            matrixStack.translate(0.5, 0.375, 0.5);
            matrixStack.scale(0.25f, 0.25f, 0.25f);
        } else if (te.getBlockState().is((Block)BlockRegistry.karotStatue.get()) || te.getBlockState().is((Block)BlockRegistry.theWatcherStatue.get()) || te.getBlockState().is((Block)BlockRegistry.experiencedCoriStatue.get())) {
            matrixStack.translate(0.5, 0.9, 0.5);
            matrixStack.scale(0.6f, 0.6f, 0.6f);
        } else {
            matrixStack.translate(0.5, 0.6, 0.5);
            if (te.getBlockState().is((Block)BlockRegistry.kitraStatue.get())) {
                matrixStack.scale(0.25f, 0.25f, 0.25f);
            } else {
                matrixStack.scale(0.4f, 0.4f, 0.4f);
            }
        }
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - RotationSegment.convertToDegrees((int)((Integer)te.getBlockState().getValue((Property)BlockStatue.ROTATION)))));
        matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        VertexConsumer builder = te.getBlockState().is((Block)BlockRegistry.kitraStatue.get()) ? buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.texture(te))) : buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture(te)));
        model.renderToBuffer(matrixStack, builder, combinedLight, combinedOverlay);
        matrixStack.popPose();
    }

    private Model getModel(StatueBlockEntity tile) {
        Block block = tile.getBlockState().getBlock();
        if (block == BlockRegistry.ancientEntityStatue.get()) {
            return new ModelAncientEntity(this.context.bakeLayer(ModelAncientEntity.LAYER_LOCATION));
        }
        if (block == BlockRegistry.theWatcherStatue.get()) {
            return new ModelWatcher(this.context.bakeLayer(ModelWatcher.LAYER_LOCATION));
        }
        if (block == BlockRegistry.kingOfScorchersStatue.get()) {
            return new ModelKingOfScorchers(this.context.bakeLayer(ModelKingOfScorchers.LAYER_LOCATION));
        }
        if (block == BlockRegistry.kitraStatue.get()) {
            return new ModelKitra(this.context.bakeLayer(ModelKitra.LAYER_LOCATION));
        }
        if (block == BlockRegistry.ayeracoStatue.get()) {
            return new ModelAyeraco(this.context.bakeLayer(ModelAyeraco.LAYER_LOCATION));
        }
        if (block == BlockRegistry.dramixStatue.get()) {
            return new ModelDramix(this.context.bakeLayer(ModelDramix.LAYER_LOCATION));
        }
        if (block == BlockRegistry.parasectaStatue.get()) {
            return new ModelParasecta(this.context.bakeLayer(ModelParasecta.LAYER_LOCATION));
        }
        if (block == BlockRegistry.sunstormStatue.get()) {
            return new ModelSunstorm(this.context.bakeLayer(ModelSunstorm.LAYER_LOCATION));
        }
        if (block == BlockRegistry.termasectStatue.get()) {
            return new ModelTermasect(this.context.bakeLayer(ModelTermasect.LAYER_LOCATION));
        }
        if (block == BlockRegistry.eternalArcherStatue.get()) {
            return new ModelEternalArcher(this.context.bakeLayer(ModelEternalArcher.LAYER_LOCATION));
        }
        if (block == BlockRegistry.experiencedCoriStatue.get()) {
            return new ModelExperiencedCori(this.context.bakeLayer(ModelExperiencedCori.LAYER_LOCATION));
        }
        if (block == BlockRegistry.vamacheronStatue.get()) {
            return new ModelVamacheron(this.context.bakeLayer(ModelVamacheron.LAYER_LOCATION));
        }
        if (block == BlockRegistry.karotStatue.get()) {
            return new ModelKarot(this.context.bakeLayer(ModelKarot.LAYER_LOCATION));
        }
        if (block == BlockRegistry.twilightDemonStatue.get()) {
            return new ModelTwilightDemon(this.context.bakeLayer(ModelTwilightDemon.LAYER_LOCATION));
        }
        if (block == BlockRegistry.densosStatue.get()) {
            return new ModelDensos(this.context.bakeLayer(ModelDensos.LAYER_LOCATION));
        }
        if (block == BlockRegistry.reyvorStatue.get()) {
            return new ModelDensos(this.context.bakeLayer(ModelDensos.LAYER_LOCATION));
        }
        if (block == BlockRegistry.soulFiendStatue.get()) {
            return new ModelSoulFiend(this.context.bakeLayer(ModelSoulFiend.LAYER_LOCATION));
        }
        return new BookModel(this.context.bakeLayer(ModelLayers.BOOK));
    }

    private static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("textures/entity/" + path + ".png"));
    }

    private ResourceLocation texture(StatueBlockEntity tile) {
        Block block = tile.getBlockState().getBlock();
        if (block == BlockRegistry.ancientEntityStatue.get()) {
            return RenderStatue.location("ancient_entity");
        }
        if (block == BlockRegistry.theWatcherStatue.get()) {
            return RenderStatue.location("the_watcher");
        }
        if (block == BlockRegistry.kingOfScorchersStatue.get()) {
            return RenderStatue.location("king_of_scorchers");
        }
        if (block == BlockRegistry.kitraStatue.get()) {
            return RenderStatue.location("kitra");
        }
        if (block == BlockRegistry.ayeracoStatue.get()) {
            return switch ((BlockColor)((Object)tile.getBlockState().getValue(BlockStatueColored.COLOR))) {
                case BlockColor.RED -> RenderStatue.location("ayeraco_red");
                case BlockColor.YELLOW -> RenderStatue.location("ayeraco_yellow");
                case BlockColor.GREEN -> RenderStatue.location("ayeraco_green");
                case BlockColor.BLUE -> RenderStatue.location("ayeraco_blue");
                case BlockColor.PURPLE -> RenderStatue.location("ayeraco_purple");
                case BlockColor.PINK -> RenderStatue.location("ayeraco_pink");
                default -> RenderStatue.location("ayeraco_white");
            };
        }
        if (block == BlockRegistry.dramixStatue.get()) {
            return RenderStatue.location("dramix");
        }
        if (block == BlockRegistry.parasectaStatue.get()) {
            return RenderStatue.location("parasecta");
        }
        if (block == BlockRegistry.sunstormStatue.get()) {
            return RenderStatue.location("sunstorm");
        }
        if (block == BlockRegistry.termasectStatue.get()) {
            return RenderStatue.location("termasect");
        }
        if (block == BlockRegistry.eternalArcherStatue.get()) {
            return RenderStatue.location("eternal_archer");
        }
        if (block == BlockRegistry.experiencedCoriStatue.get()) {
            return RenderStatue.location("experienced_cori");
        }
        if (block == BlockRegistry.vamacheronStatue.get()) {
            return RenderStatue.location("vamacheron");
        }
        if (block == BlockRegistry.karotStatue.get()) {
            return RenderStatue.location("karot");
        }
        if (block == BlockRegistry.twilightDemonStatue.get()) {
            return RenderStatue.location("twilight_demon");
        }
        if (block == BlockRegistry.densosStatue.get()) {
            return RenderStatue.location("densos");
        }
        if (block == BlockRegistry.reyvorStatue.get()) {
            return RenderStatue.location("reyvor");
        }
        if (block == BlockRegistry.soulFiendStatue.get()) {
            return RenderStatue.location("soul_fiend");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/block/black_hungerstone.png");
    }
}

