/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.recipebook.AbstractFurnaceRecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.SmeltingRecipeBookComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class DivineFurnaceScreen<T extends AbstractFurnaceMenu>
extends AbstractFurnaceScreen<T> {
    public static final ResourceLocation FLAME_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"furnace_flame");
    public static final ResourceLocation PROGRESS_ARROW_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"progress_arrow");
    private final int titleColor;
    private final int invColor;

    public DivineFurnaceScreen(T container, Inventory inv, Component c, ResourceLocation location, int titleColor, int invColor, ResourceLocation flame_sprite) {
        super(container, (AbstractFurnaceRecipeBookComponent)new SmeltingRecipeBookComponent(), inv, c, location, flame_sprite, PROGRESS_ARROW_SPRITE);
        this.titleColor = titleColor;
        this.invColor = invColor;
    }

    public DivineFurnaceScreen(T container, Inventory inv, Component c, ResourceLocation location, int titleColor, int invColor) {
        super(container, (AbstractFurnaceRecipeBookComponent)new SmeltingRecipeBookComponent(), inv, c, location, FLAME_SPRITE, PROGRESS_ARROW_SPRITE);
        this.titleColor = titleColor;
        this.invColor = invColor;
    }

    protected void renderLabels(GuiGraphics stack, int p_282681_, int p_283686_) {
        stack.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, this.titleColor, false);
        stack.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.invColor, false);
    }
}

