/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.slot;

import divinerpg.client.menu.InfusionTableMenu;
import divinerpg.recipe.InfusionTableRecipe;
import divinerpg.registries.RecipeRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class InfusionTableResultSlot
extends Slot {
    private final InfusionTableMenu.InfusionInventory craftSlots;
    private final Player player;
    private int removeCount;

    public InfusionTableResultSlot(Player player, InfusionTableMenu.InfusionInventory craftSlots, ResultContainer inventory, int index, int xpos, int ypos) {
        super((Container)inventory, index, xpos, ypos);
        this.player = player;
        this.craftSlots = craftSlots;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    protected void onSwapCraft(int amount) {
        this.removeCount += amount;
    }

    protected void checkTakeAchievements(ItemStack stack) {
        stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        this.removeCount = 0;
        EventHooks.firePlayerSmeltedEvent((Player)this.player, (ItemStack)stack);
    }

    public void onTake(Player player, ItemStack stack) {
        if (player.level() != null && !player.level().isClientSide()) {
            this.checkTakeAchievements(stack);
            CommonHooks.setCraftingPlayer((Player)player);
            Optional recipe = player.level().getServer().getRecipeManager().getRecipeFor((RecipeType)RecipeRegistry.Types.INFUSION_TABLE_RECIPE_TYPE.get(), (RecipeInput)CraftingInput.of((int)1, (int)2, List.of(this.craftSlots.getItem(0), this.craftSlots.getItem(1))), player.level());
            CommonHooks.setCraftingPlayer(null);
            recipe.ifPresent(r -> this.craftSlots.getItem(0).shrink(((InfusionTableRecipe)r.value()).input().getCount()));
            super.onTake(player, stack);
        }
    }
}

