/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei;

import divinerpg.client.screen.ArcaniumExtractorScreen;
import divinerpg.client.screen.InfusionTableScreen;
import divinerpg.compat.jei.brewing.PotionRecipe;
import divinerpg.compat.jei.category.ArcaniumExtractorCategory;
import divinerpg.compat.jei.category.FireConversionCategory;
import divinerpg.compat.jei.category.InfusionTableCategory;
import divinerpg.compat.jei.category.MerchantTradeCategory;
import divinerpg.compat.jei.category.SmashingCategory;
import divinerpg.compat.jei.ingredient.BlockIngredientHelper;
import divinerpg.compat.jei.ingredient.BlockIngredientRenderer;
import divinerpg.entities.base.EntityDivineMerchant;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.PotionRegistry;
import divinerpg.registries.RecipeRegistry;
import divinerpg.registries.TagRegistry;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"jei_plugin");
    public static final IIngredientType<Block> BLOCK_INGREDIENT_TYPE = () -> Block.class;
    static final RandomSource random = RandomSource.create();

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalysts(RecipeTypes.SMELTING, Ingredient.of(TagRegistry.FURNACES).getItems());
        registration.addRecipeCatalysts(SmashingCategory.RECIPE_TYPE, Ingredient.of(TagRegistry.TOOLS_MAUL).getItems());
        registration.addRecipeCatalyst(BlockRegistry.arcaniumExtractor, new RecipeType[]{ArcaniumExtractorCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(BlockRegistry.infusionTable, new RecipeType[]{InfusionTableCategory.RECIPE_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(ArcaniumExtractorCategory.RECIPE_TYPE, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.Types.ARCANIUM_EXTRACTOR_RECIPE_TYPE.get()));
        registration.addRecipes(InfusionTableCategory.RECIPE_TYPE, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.Types.INFUSION_TABLE_RECIPE_TYPE.get()));
        registration.addRecipes(SmashingCategory.RECIPE_TYPE, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.Types.MAUL_SMASHING.get()));
        registration.addRecipes(FireConversionCategory.RECIPE_TYPE, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.Types.FIRE_CONVERSION.get()));
        registration.addRecipes(RecipeTypes.BREWING, List.of(new PotionRecipe(Items.POTION, (Holder<Potion>)Potions.AWKWARD, (Holder<Potion>)PotionRegistry.GROG, 2, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"brewing.grog.regular"), ItemRegistry.cauldron_flesh.toStack()), new PotionRecipe(Items.SPLASH_POTION, (Holder<Potion>)Potions.AWKWARD, (Holder<Potion>)PotionRegistry.GROG, 3, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"brewing.grog.splash"), ItemRegistry.cauldron_flesh.toStack()), new PotionRecipe(Items.LINGERING_POTION, (Holder<Potion>)Potions.AWKWARD, (Holder<Potion>)PotionRegistry.GROG, 4, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"brewing.grog.lingering"), ItemRegistry.cauldron_flesh.toStack()), new PotionRecipe(Items.POTION, (Holder<Potion>)PotionRegistry.TEA, (Holder<Potion>)PotionRegistry.WARMTH, 2, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"brewing.warmth.regular"), ItemRegistry.olivine.toStack()), new PotionRecipe(Items.SPLASH_POTION, (Holder<Potion>)PotionRegistry.TEA, (Holder<Potion>)PotionRegistry.WARMTH, 3, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"brewing.warmth.splash"), ItemRegistry.olivine.toStack()), new PotionRecipe(Items.LINGERING_POTION, (Holder<Potion>)PotionRegistry.TEA, (Holder<Potion>)PotionRegistry.WARMTH, 4, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"brewing.warmth.lingering"), ItemRegistry.olivine.toStack()), new PotionRecipe(Items.POTION, (Holder<Potion>)Potions.WATER, (Holder<Potion>)PotionRegistry.TEA, 1, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"brewing.tea.regular"), ItemRegistry.winterberry.toStack(), Items.SWEET_BERRIES.getDefaultInstance()), new PotionRecipe(Items.SPLASH_POTION, (Holder<Potion>)Potions.WATER, (Holder<Potion>)PotionRegistry.TEA, 2, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"brewing.tea.splash"), ItemRegistry.winterberry.toStack(), Items.SWEET_BERRIES.getDefaultInstance()), new PotionRecipe(Items.LINGERING_POTION, (Holder<Potion>)Potions.WATER, (Holder<Potion>)PotionRegistry.TEA, 3, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"brewing.tea.lingering"), ItemRegistry.winterberry.toStack(), Items.SWEET_BERRIES.getDefaultInstance())));
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.LIVESTOCK_MERCHANT, "livestock_merchant");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.JACK_O_MAN, "jack_o_man");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.DIAMOND_DAVE, "diamond_dave");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.WORKSHOP_MERCHANT, "workshop_merchant");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.WORKSHOP_TINKERER, "workshop_tinkerer");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GROGLIN_CHIEFTAIN, "groglin_chieftain");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GROGLIN_HUNTER, "groglin_hunter");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GROGLIN_MERCHANT, "groglin_merchant");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GROGLIN_RANGER, "groglin_ranger");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GROGLIN_SHARLATAN, "groglin_sharlatan");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GROGLIN_WARRIOR, "groglin_warrior");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GRUZZORLUG_CANNONEER, "gruzzorlug_cannoneer");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GRUZZORLUG_COMMANDER, "gruzzorlug_commander");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GRUZZORLUG_GENERAL, "gruzzorlug_general");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GRUZZORLUG_KNIGHT, "gruzzorlug_knight");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GRUZZORLUG_MINER, "gruzzorlug_miner");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.GRUZZORLUG_SWORDSMAN, "gruzzorlug_swordsman");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.CAPTAIN_MERIK, "captain_merik");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.DATTICON, "datticon");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.KAZARI, "kazari");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.LEORNA, "leorna");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.LORD_VATTICUS, "lord_vatticus");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.WAR_GENERAL, "war_general");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.ZELUS, "zelus");
        JEICompat.registerMerchantTrade(registration, RecipeRegistry.Trades.THE_HUNGER, "the_hunger");
        JEICompat.registerIngredientInfo(registration, List.of(ItemRegistry.armor_pouch.toStack(), ItemRegistry.red_armor_pouch.toStack(), ItemRegistry.yellow_armor_pouch.toStack(), ItemRegistry.green_armor_pouch.toStack(), ItemRegistry.blue_armor_pouch.toStack(), ItemRegistry.gray_armor_pouch.toStack()), ItemRegistry.armor_pouch.getId().getPath());
        JEICompat.registerIngredientInfo(registration, ItemRegistry.frozen_clock, ItemRegistry.frozen_clock.getId().getPath());
        JEICompat.registerIngredientInfo(registration, ItemRegistry.collector, ItemRegistry.collector.getId().getPath());
        JEICompat.registerIngredientInfo(registration, ItemRegistry.firestock, ItemRegistry.firestock.getId().getPath());
        JEICompat.registerIngredientInfo(registration, ItemRegistry.acid, ItemRegistry.acid.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.icyFire, BlockRegistry.icyFire.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.asphalt, BlockRegistry.asphalt.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.rawArcanium, BlockRegistry.rawArcanium.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.encagedCaptainMerik, BlockRegistry.encagedCaptainMerik.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.encagedDatticon, BlockRegistry.encagedDatticon.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.encagedKazari, BlockRegistry.encagedKazari.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.encagedLeorna, BlockRegistry.encagedLeorna.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.encagedLordVatticus, BlockRegistry.encagedLordVatticus.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.encagedWarGeneral, BlockRegistry.encagedWarGeneral.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.encagedZelus, BlockRegistry.encagedZelus.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.dramixAltar, BlockRegistry.dramixAltar.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.parasectaAltar, BlockRegistry.parasectaAltar.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.hiveEgg, BlockRegistry.hiveEgg.getId().getPath());
        JEICompat.registerIngredientInfo(registration, List.of(BlockRegistry.miner.toStack(), BlockRegistry.softMiner.toStack()), BlockRegistry.miner.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.elevantium, BlockRegistry.elevantium.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.soulTrap, BlockRegistry.soulTrap.getId().getPath());
        JEICompat.registerIngredientInfo(registration, BlockRegistry.nightmareBed, BlockRegistry.nightmareBed.getId().getPath());
    }

    static void registerMerchantTrade(IRecipeRegistration registration, RecipeRegistry.Trades.TradeGetter getter, String profession) {
        EntityDivineMerchant.DivineTrades[] trades;
        ClientLevel level = Minecraft.getInstance().level;
        MutableComponent name = Component.translatable((String)("entity.divinerpg." + profession));
        for (EntityDivineMerchant.DivineTrades trade : trades = getter.get((Level)level, random)) {
            trade.name = name;
        }
        registration.addRecipes(MerchantTradeCategory.RECIPE_TYPE, List.of(trades));
    }

    static void registerIngredientInfo(IRecipeRegistration registration, ItemLike item, String description) {
        MutableComponent name = Component.translatable((String)("info.divinerpg.jei." + description));
        registration.addIngredientInfo(item, new Component[]{name});
    }

    static void registerIngredientInfo(IRecipeRegistration registration, List<ItemStack> item, String description) {
        MutableComponent name = Component.translatable((String)("info.divinerpg.jei." + description));
        registration.addItemStackInfo(item, new Component[]{name});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ArcaniumExtractorCategory(helper), new InfusionTableCategory(helper), new SmashingCategory(helper), new FireConversionCategory(helper), new MerchantTradeCategory(helper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(BLOCK_INGREDIENT_TYPE, List.of(), (IIngredientHelper)new BlockIngredientHelper(), (IIngredientRenderer)new BlockIngredientRenderer(), Block.CODEC.codec());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ArcaniumExtractorScreen.class, 79, 34, 24, 16, new RecipeType[]{new RecipeType(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcanium_extractor"), RecipeHolder.class)});
        registration.addRecipeClickArea(InfusionTableScreen.class, 36, 47, 25, 18, new RecipeType[]{new RecipeType(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"infusion_table"), RecipeHolder.class)});
    }
}

