/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei;

import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.LootTableRegistry;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IJERAPI;
import jeresources.api.IPlantRegistry;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.compatibility.api.JERAPI;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class JERCompat {
    public static void init() {
        IPlantRegistry plantRegistry;
        IWorldGenRegistry worldGenRegistry;
        IJERAPI jerApi = JERAPI.getInstance();
        IDungeonRegistry dungeonRegistry = jerApi.getDungeonRegistry();
        if (dungeonRegistry != null) {
            dungeonRegistry.registerChest(JERCompat.getDungeon("diamond_dave_geode"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.AMETHYST_GEODE));
            dungeonRegistry.registerChest(JERCompat.getDungeon("ancient_tomb"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.ANCIENT_TOMB));
            dungeonRegistry.registerChest(JERCompat.getDungeon("livestock_merchant_hut"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.LIVESTOCK_MERCHANT_HUT));
            dungeonRegistry.registerChest(JERCompat.getDungeon("iceika_dungeon"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.ICEIKA_DUNGEON));
            dungeonRegistry.registerChest(JERCompat.getDungeon("iceika_hut"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.ICEIKA_HUT));
            dungeonRegistry.registerChest(JERCompat.getDungeon("groglin_village"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.GROGLIN_VILLAGE));
            dungeonRegistry.registerChest(JERCompat.getDungeon("gruzzorlug_village"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.GRUZZORLUG_VILLAGE));
            dungeonRegistry.registerChest(JERCompat.getDungeon("banquet_hall"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.BANQUET_HALL));
            dungeonRegistry.registerChest(JERCompat.getDungeon("utility_hallway"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.UTILITY_HALLWAY));
            dungeonRegistry.registerChest(JERCompat.getDungeon("eden_hut"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.EDEN_HUT));
            dungeonRegistry.registerChest(JERCompat.getDungeon("skythern_hut"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.SKYTHERN_HUT));
            dungeonRegistry.registerChest(JERCompat.getDungeon("wildwood_hut"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.WILDWOOD_HUT));
            dungeonRegistry.registerChest(JERCompat.getDungeon("crypt"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.CRYPT));
            dungeonRegistry.registerChest(JERCompat.getDungeon("karos_madhouse"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.KAROS_MADHOUSE));
            dungeonRegistry.registerChest(JERCompat.getDungeon("quadrotic_post"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.QUADROTIC_POST));
            dungeonRegistry.registerChest(JERCompat.getDungeon("raglok_chamber"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.RAGLOK_CHAMBER));
            dungeonRegistry.registerChest(JERCompat.getDungeon("temple_bottom"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.TEMPLE_BOTTOM));
            dungeonRegistry.registerChest(JERCompat.getDungeon("temple_middle"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.TEMPLE_MIDDLE));
            dungeonRegistry.registerChest(JERCompat.getDungeon("temple_top"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.TEMPLE_TOP));
            dungeonRegistry.registerChest(JERCompat.getDungeon("wreck_hall"), ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LootTableRegistry.WRECK_HALL));
        }
        if ((worldGenRegistry = jerApi.getWorldGenRegistry()) != null) {
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.realmiteOre.get()), new ItemStack((ItemLike)BlockRegistry.realmiteOreDeepslate.get()), (DistributionBase)new DistributionSquare(30, 8, 28, 52), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.raw_realmite.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.arlemiteOre.get()), new ItemStack((ItemLike)BlockRegistry.arlemiteOreDeepslate.get()), (DistributionBase)new DistributionSquare(2, 8, 5, 70), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.raw_arlemite.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.rupeeOre.get()), new ItemStack((ItemLike)BlockRegistry.rupeeOreDeepslate.get()), (DistributionBase)new DistributionSquare(3, 8, -64, 64), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.raw_rupee.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.torriditeOre.get()), (DistributionBase)new DistributionSquare(5, 4, 8, 120), new Restriction(new DimensionRestriction(Level.NETHER)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.raw_torridite.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.bloodgemOre.get()), (DistributionBase)new DistributionSquare(5, 4, 8, 120), new Restriction(new DimensionRestriction(Level.NETHER)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.bloodgem.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.anthraciteOre.get()), (DistributionBase)new DistributionSquare(16, 12, 45, 318), new Restriction(new DimensionRestriction(LevelRegistry.ICEIKA)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.anthracite.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.oxdriteOre.get()), (DistributionBase)new DistributionSquare(8, 8, 64, 128), new Restriction(new DimensionRestriction(LevelRegistry.ICEIKA)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.raw_oxdrite.get()), 2, 20, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.oxdriteOre.get()), (DistributionBase)new DistributionSquare(16, 8, -64, 64), new Restriction(new DimensionRestriction(LevelRegistry.ICEIKA)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.raw_oxdrite.get()), 2, 20, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.twilightEdenOre.get()), (DistributionBase)new DistributionSquare(12, 5, 0, 256), new Restriction(new DimensionRestriction(LevelRegistry.EDEN)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.eden_fragments.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.scorchaltEdenOre.get()), (DistributionBase)new DistributionSquare(12, 5, 0, 256), new Restriction(new DimensionRestriction(LevelRegistry.EDEN)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.eden_fragments.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.wildwoodOre.get()), (DistributionBase)new DistributionSquare(6, 8, -64, 256), new Restriction(new DimensionRestriction(LevelRegistry.WILDWOOD)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.wildwood_fragments.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.apalachiaOre.get()), (DistributionBase)new DistributionSquare(12, 12, -64, 256), new Restriction(new DimensionRestriction(LevelRegistry.APALACHIA)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.apalachia_fragments.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.skythernOre.get()), (DistributionBase)new DistributionSquare(7, 6, -64, 256), new Restriction(new DimensionRestriction(LevelRegistry.SKYTHERN)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.skythern_fragments.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
            worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.mortumOre.get()), (DistributionBase)new DistributionSquare(5, 5, -64, 256), new Restriction(new DimensionRestriction(LevelRegistry.MORTUM)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemRegistry.mortum_fragments.get()), 1, 4, new Conditional[]{Conditional.affectedByFortune})});
        }
        if ((plantRegistry = jerApi.getPlantRegistry()) != null) {
            plantRegistry.register(new ItemStack((ItemLike)ItemRegistry.tomato_seeds.get()), ((Block)BlockRegistry.tomatoPlant.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.tomato.get()), 2, 5)});
            plantRegistry.register(new ItemStack((ItemLike)ItemRegistry.white_mushroom_seeds.get()), ((Block)BlockRegistry.whiteMushroomPlant.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.white_mushroom.get()), 2, 5)});
            plantRegistry.registerWithSoil(new ItemStack((ItemLike)ItemRegistry.winterberry.get()), ((Block)BlockRegistry.winterberryBush.get()).defaultBlockState(), ((Block)BlockRegistry.brittleMoss.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.winterberry.get()), 1, 1)});
            plantRegistry.register(new ItemStack((ItemLike)ItemRegistry.aquamarine_seeds.get()), ((Block)BlockRegistry.aquamarinePlant.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.aquamarine.get()), 1, 1), new PlantDrop(new ItemStack((ItemLike)ItemRegistry.aquamarine_seeds.get()), 1, 4)});
            plantRegistry.register(new ItemStack((ItemLike)ItemRegistry.eucalyptus_root_seeds.get()), ((Block)BlockRegistry.eucalyptusPlant.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)BlockRegistry.eucalyptusLog.get()), 1, 1), new PlantDrop(new ItemStack((ItemLike)ItemRegistry.eucalyptus_root_seeds.get()), 1, 4)});
            plantRegistry.register(new ItemStack((ItemLike)ItemRegistry.hitchak_seeds.get()), ((Block)BlockRegistry.hitchakPlant.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.hitchak.get()), 2, 5)});
            plantRegistry.register(new ItemStack((ItemLike)ItemRegistry.lamona_seeds.get()), ((Block)BlockRegistry.lamonaPlant.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.lamona.get()), 2, 5)});
            plantRegistry.register(new ItemStack((ItemLike)ItemRegistry.marsine_seeds.get()), ((Block)BlockRegistry.marsinePlant.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.marsine.get()), 2, 5)});
            plantRegistry.register(new ItemStack((ItemLike)ItemRegistry.veilo_seeds.get()), ((Block)BlockRegistry.veiloPlant.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.veilo.get()), 2, 5)});
            plantRegistry.registerWithSoil(new ItemStack((ItemLike)ItemRegistry.firestock_seeds.get()), ((Block)BlockRegistry.firestockPlant.get()).defaultBlockState(), ((Block)BlockRegistry.arcaniteGrass.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.firestock.get()), 2, 5)});
            plantRegistry.registerWithSoil(new ItemStack((ItemLike)ItemRegistry.pinfly_seeds.get()), ((Block)BlockRegistry.pinflyPlant.get()).defaultBlockState(), ((Block)BlockRegistry.arcaniteGrass.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.pinfly.get()), 2, 5)});
            plantRegistry.registerWithSoil(new ItemStack((ItemLike)ItemRegistry.moonbulb_seeds.get()), ((Block)BlockRegistry.moonbulbPlant.get()).defaultBlockState(), Blocks.GRASS_BLOCK.defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.moonbulb.get()), 2, 5)});
            plantRegistry.registerWithSoil(new ItemStack((ItemLike)ItemRegistry.purple_glowbone_seeds.get()), ((Block)BlockRegistry.purpleGlowbonePlant.get()).defaultBlockState(), Blocks.GRASS_BLOCK.defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.purple_glowbone.get()), 2, 5)});
            plantRegistry.registerWithSoil(new ItemStack((ItemLike)ItemRegistry.pink_glowbone_seeds.get()), ((Block)BlockRegistry.pinkGlowbonePlant.get()).defaultBlockState(), Blocks.GRASS_BLOCK.defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.pink_glowbone.get()), 2, 5)});
            plantRegistry.register(new ItemStack((ItemLike)ItemRegistry.sky_plant_seeds.get()), ((Block)BlockRegistry.skyPlant.get()).defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)ItemRegistry.sky_flower.get()), 1, 1), new PlantDrop(new ItemStack((ItemLike)ItemRegistry.sky_plant_seeds.get()), 1, 4)});
        }
    }

    public static String getDungeon(String name) {
        return JERCompat.dungeonName(name, new Object[0]).getString();
    }

    public static Component dungeonName(String text, Object ... args) {
        if (args == null) {
            args = new Object[]{};
        }
        MutableComponent result = MutableComponent.create((ComponentContents)new TranslatableContents(String.format("dungeon.divinerpg.%s", text), null, args));
        return result.withStyle(ChatFormatting.GRAY);
    }
}

