/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei.category;

import divinerpg.compat.jei.JEICompat;
import divinerpg.recipe.FireConversionRecipe;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.RecipeRegistry;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class FireConversionCategory
implements IRecipeCategory<RecipeHolder<FireConversionRecipe>> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/gui/jei/conversion.png");
    public static final ResourceLocation PLUS = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/gui/jei/plus.png");
    public static final ResourceLocation SLOT = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/container/slot.png");
    public static final RecipeType<RecipeHolder<FireConversionRecipe>> RECIPE_TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.Types.FIRE_CONVERSION.get()));
    private static final RandomSource random = RandomSource.create();
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable plus;
    private final IDrawable slot;

    public FireConversionCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 74, 60).setTextureSize(74, 60).build();
        this.plus = helper.drawableBuilder(PLUS, 0, 0, 13, 13).setTextureSize(13, 13).build();
        this.slot = helper.drawableBuilder(SLOT, 0, 0, 18, 18).setTextureSize(18, 18).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)BlockRegistry.divineFlame.toStack());
    }

    public RecipeType<RecipeHolder<FireConversionRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"tooltip.divinerpg.jei.fire_conversion");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<FireConversionRecipe> recipe, IFocusGroup focuses) {
        builder.addInputSlot(2, 2).addIngredients(((FireConversionRecipe)recipe.value()).inputItem());
        RuleTest test = ((FireConversionRecipe)recipe.value()).inputState();
        IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, 2, 38);
        IIngredientAcceptor ingredients = builder.addInvisibleIngredients(RecipeIngredientRole.INPUT);
        BuiltInRegistries.FLUID.forEach(f -> {
            if (test.test(f.defaultFluidState().createLegacyBlock(), random)) {
                slot.addFluidStack(f);
            }
        });
        BuiltInRegistries.BLOCK.getTag(BlockTags.FIRE).ifPresent(tag -> tag.forEach(block -> {
            Block b = (Block)block.value();
            if (test.test(b.defaultBlockState(), random)) {
                slot.addIngredient(JEICompat.BLOCK_INGREDIENT_TYPE, (Object)b);
                ingredients.addItemStack(b.asItem().getDefaultInstance());
            }
        }));
        ((FireConversionRecipe)recipe.value()).outputItem().ifPresent(stack -> {
            if (!stack.isEmpty()) {
                builder.addOutputSlot(53, 2).addItemStack(stack);
            }
        });
        ((FireConversionRecipe)recipe.value()).outputState().ifPresent(s -> {
            BlockState state = s.getState(random, BlockPos.ZERO);
            if (!state.isAir()) {
                if (!state.getFluidState().isEmpty()) {
                    builder.addOutputSlot(53, 38).addFluidStack(state.getFluidState().getType());
                } else {
                    builder.addOutputSlot(53, 38).addIngredient(JEICompat.BLOCK_INGREDIENT_TYPE, (Object)state.getBlock());
                }
                builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(state.getBlock().asItem().getDefaultInstance());
            }
        });
    }

    public void draw(RecipeHolder<FireConversionRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        if (((FireConversionRecipe)recipe.value()).outputItem().isPresent() && !((FireConversionRecipe)recipe.value()).outputItem().get().isEmpty()) {
            this.slot.draw(guiGraphics, 52, 1);
            if (((FireConversionRecipe)recipe.value()).outputState().isPresent() && !((FireConversionRecipe)recipe.value()).outputState().get().getState(random, BlockPos.ZERO).isAir()) {
                this.plus.draw(guiGraphics, 54, 22);
            }
        }
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }
}

