/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei.category;

import divinerpg.entities.base.EntityDivineMerchant;
import divinerpg.registries.ItemRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class MerchantTradeCategory
implements IRecipeCategory<EntityDivineMerchant.DivineTrades> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/gui/jei/merchant_trade.png");
    public static final RecipeType<EntityDivineMerchant.DivineTrades> RECIPE_TYPE = RecipeType.create((String)"divinerpg", (String)"merchant_trades", EntityDivineMerchant.DivineTrades.class);
    static final int OFFSET = 6;
    private final IDrawable icon;
    private final IDrawable background;

    public MerchantTradeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 88, 36).setTextureSize(88, 36).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ItemRegistry.olivine.toStack());
    }

    public RecipeType<EntityDivineMerchant.DivineTrades> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"tooltip.divinerpg.jei.merchant_trades");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EntityDivineMerchant.DivineTrades recipe, IFocusGroup focuses) {
        if (recipe.input1 != null) {
            builder.addInputSlot(11, 17).addItemStack(recipe.input1);
        }
        if (recipe.input2 != null) {
            builder.addInputSlot(41, 17).addItemStack(recipe.input2);
        }
        if (recipe instanceof EntityDivineMerchant.DivineMapTrades) {
            EntityDivineMerchant.DivineMapTrades m = (EntityDivineMerchant.DivineMapTrades)recipe;
            ItemStack itemstack = new ItemStack((ItemLike)Items.FILLED_MAP);
            MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)BlockPos.ZERO, (String)"+", m.destinationType);
            itemstack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)m.displayName));
            builder.addOutputSlot(74, 17).addItemStack(itemstack);
        } else {
            builder.addOutputSlot(74, 17).addItemStack(recipe.output);
        }
    }

    public void draw(EntityDivineMerchant.DivineTrades recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 6, 0);
        TextColor c = recipe.name.getStyle().getColor();
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, recipe.name, 50, 1, c == null ? 0xFFFFFF : c.getValue());
    }

    public int getWidth() {
        return this.background.getWidth() + 12;
    }

    public int getHeight() {
        return this.background.getHeight();
    }
}

