/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei.category;

import divinerpg.compat.jei.JEICompat;
import divinerpg.compat.jei.category.FireConversionCategory;
import divinerpg.recipe.MaulSmashingRecipe;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.RecipeRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class SmashingCategory
implements IRecipeCategory<RecipeHolder<MaulSmashingRecipe>> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/gui/jei/smashing.png");
    public static final RecipeType<RecipeHolder<MaulSmashingRecipe>> RECIPE_TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.Types.MAUL_SMASHING.get()));
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable plus;

    public SmashingCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 74, 60).setTextureSize(74, 60).build();
        this.plus = helper.drawableBuilder(FireConversionCategory.PLUS, 0, 0, 13, 13).setTextureSize(13, 13).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ItemRegistry.realmite_maul.toStack());
    }

    public RecipeType<RecipeHolder<MaulSmashingRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"tooltip.divinerpg.jei.smashing");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<MaulSmashingRecipe> recipe, IFocusGroup focuses) {
        builder.addInputSlot(2, 2).addIngredients(((MaulSmashingRecipe)recipe.value()).input());
        if (((MaulSmashingRecipe)recipe.value()).requiredBaseBlockTag() != null) {
            BuiltInRegistries.BLOCK.getTag(((MaulSmashingRecipe)recipe.value()).requiredBaseBlockTag()).ifPresent(holders -> {
                IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, 2, 38);
                IIngredientAcceptor ingredients = builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST);
                holders.forEach(block -> {
                    Block b = (Block)block.value();
                    if (b.defaultBlockState().getFluidState().isEmpty()) {
                        slot.addIngredient(JEICompat.BLOCK_INGREDIENT_TYPE, (Object)b);
                    } else {
                        slot.addFluidStack(b.defaultBlockState().getFluidState().getType());
                    }
                    ingredients.addItemStack(b.asItem().getDefaultInstance());
                });
            });
        }
        builder.addOutputSlot(56, 20).addItemStack(((MaulSmashingRecipe)recipe.value()).output());
    }

    public void draw(RecipeHolder<MaulSmashingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        if (((MaulSmashingRecipe)recipe.value()).requiredBaseBlockTag() != null) {
            this.plus.draw(guiGraphics, 3, 22);
        }
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }
}

