/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.supplementaries;

import divinerpg.registries.BlockRegistry;
import java.util.ArrayList;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RakedGravelBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RakedFrozenGravel
extends RakedGravelBlock {
    public RakedFrozenGravel() {
        super(new ColorRGBA(13561077), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)BlockRegistry.frozenGravel.get())));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.defaultBlockState();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Block.pushEntitiesUp((BlockState)state, (BlockState)((Block)BlockRegistry.frozenGravel.get()).defaultBlockState(), (LevelAccessor)level, (BlockPos)pos);
        }
        Direction front = context.getHorizontalDirection();
        return RakedFrozenGravel.getConnectedState(state, (LevelAccessor)level, pos, front);
    }

    private static boolean canConnect(BlockState state, Direction dir) {
        return state.getBlock() instanceof RakedGravelBlock && ((ModBlockProperties.RakeDirection)state.getValue((Property)RAKE_DIRECTION)).getDirections().contains(dir.getOpposite());
    }

    public static BlockState getConnectedState(BlockState blockstate, LevelAccessor level, BlockPos pos, Direction front) {
        ArrayList<Direction> directionList = new ArrayList<Direction>();
        Direction back = front.getOpposite();
        if (RakedFrozenGravel.canConnect(level.getBlockState(pos.relative(back)), back)) {
            directionList.add(back);
        } else {
            directionList.add(front);
        }
        Direction side = front.getClockWise();
        for (int i = 0; i < 2; ++i) {
            BlockState state = level.getBlockState(pos.relative(side));
            if (RakedFrozenGravel.canConnect(state, side)) {
                directionList.add(side);
                break;
            }
            side = side.getOpposite();
        }
        return (BlockState)blockstate.setValue((Property)RAKE_DIRECTION, (Comparable)ModBlockProperties.RakeDirection.fromDirections(directionList));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        if (!state.canSurvive((LevelReader)level, pos)) {
            RakedFrozenGravel.turnToGravel(state, (Level)level, pos);
        }
    }

    public static void turnToGravel(BlockState state, Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, RakedFrozenGravel.pushEntitiesUp((BlockState)state, (BlockState)((Block)BlockRegistry.frozenGravel.get()).defaultBlockState(), (LevelAccessor)level, (BlockPos)pos));
    }
}

