/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import divinerpg.effect.dimension.TwilightSky;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class VetheaSky
extends DimensionSpecialEffects {
    public static final ResourceLocation EYE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/particle/eye.png");
    @Nullable
    private VertexBuffer starBuffer;

    public VetheaSky() {
        super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        MeshData bufferbuilder$renderedbuffer = TwilightSky.drawStars(tesselator);
        this.starBuffer.bind();
        this.starBuffer.upload(bufferbuilder$renderedbuffer);
        VertexBuffer.unbind();
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 vec, float f) {
        return vec.scale(0.15);
    }

    public boolean isFoggyAt(int i, int ii) {
        return false;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogtype;
        setupFog.run();
        if (!isFoggy && (fogtype = camera.getFluidInCamera()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !TwilightSky.doesMobEffectBlockSky(camera)) {
            Vec3 vec3 = level.getSkyColor(camera.getPosition(), partialTick);
            float f = (float)vec3.x;
            float f1 = (float)vec3.y;
            float f2 = (float)vec3.z;
            FogRenderer.levelFogColor();
            Tesselator tesselator = Tesselator.getInstance();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            float f11 = 1.0f - level.getRainLevel(partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            modelViewMatrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f));
            float f12 = 20.0f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)EYE_LOCATION);
            int k = level.getMoonPhase();
            int l = k % 4;
            int i1 = k / 4 % 2;
            float f13 = (float)(l + 0) / 4.0f;
            float f14 = (float)(i1 + 0) / 2.0f;
            float f15 = (float)(l + 1) / 4.0f;
            float f16 = (float)(i1 + 1) / 2.0f;
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(modelViewMatrix, -f12, -100.0f, f12).setUv(f15, f16);
            bufferbuilder.addVertex(modelViewMatrix, f12, -100.0f, f12).setUv(f13, f16);
            bufferbuilder.addVertex(modelViewMatrix, f12, -100.0f, -f12).setUv(f13, f14);
            bufferbuilder.addVertex(modelViewMatrix, -f12, -100.0f, -f12).setUv(f15, f14);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
            float f10 = level.getStarBrightness(partialTick) * f11 * 1.01f;
            RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
            FogRenderer.setupNoFog();
            this.starBuffer.bind();
            this.starBuffer.drawWithShader(modelViewMatrix, projectionMatrix, GameRenderer.getPositionShader());
            modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * -360.0f));
            modelViewMatrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            VertexBuffer.unbind();
            setupFog.run();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }
}

