/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.mob;

import divinerpg.entities.base.FactionEntity;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.TagRegistry;
import divinerpg.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class GruzzorlugTargetEffect
extends MobEffect {
    public GruzzorlugTargetEffect() {
        super(MobEffectCategory.NEUTRAL, 7035783);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void applyInstantenousEffect(Entity entity, Entity e, LivingEntity living, int i, double d) {
    }

    public boolean applyEffectTick(LivingEntity entity, int i) {
        BlockPos structure;
        ServerLevel level;
        Level level2 = entity.level();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).getGameTime() % 80L == 0L && level.getDifficulty() != Difficulty.PEACEFUL && !level.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS) && level.canSeeSky(entity.blockPosition()) && FactionEntity.Faction.hasNearbyTarget((Entity)entity, entity.getBoundingBox().inflate(16.0), FactionEntity.Faction.GRUZZORLUG) && (structure = level.findNearestMapStructure(TagRegistry.GRUZZORLUG_RAID_TARGETS, entity.blockPosition(), 4, false)) != null && entity.distanceToSqr((double)structure.getX(), (double)entity.getBlockY(), (double)structure.getZ()) < 128.0) {
            BlockPos pos = Utils.getNearbySpawnPos(level, entity.getRandom(), entity.blockPosition());
            AttachmentRegistry.IMPORTANT.set(((EntityType)EntityRegistry.GRUZZORLUG_COMMANDER.get()).spawn(level, null, null, pos, MobSpawnType.REINFORCEMENT, false, false), false);
            EntityType ent = (EntityType)EntityRegistry.GRUZZORLUG_CANNONEER.get();
            ent.spawn(level, Utils.adjustHeight(level, pos.offset(3, 0, 0).mutable()), MobSpawnType.REINFORCEMENT);
            ent.spawn(level, Utils.adjustHeight(level, pos.offset(0, 0, 3).mutable()), MobSpawnType.REINFORCEMENT);
            ent.spawn(level, Utils.adjustHeight(level, pos.offset(0, 0, -3).mutable()), MobSpawnType.REINFORCEMENT);
            AttachmentRegistry.IMPORTANT.set(((EntityType)EntityRegistry.GRUZZORLUG_GENERAL.get()).spawn(level, null, null, Utils.adjustHeight(level, pos.offset(-3, 0, 0).mutable()), MobSpawnType.REINFORCEMENT, false, false), false);
            ((EntityType)EntityRegistry.GRUZZORLUG_KNIGHT.get()).spawn(level, Utils.adjustHeight(level, pos.offset(-6, 0, 0).mutable()), MobSpawnType.REINFORCEMENT);
            ent = (EntityType)EntityRegistry.GRUZZORLUG_SWORDSMAN.get();
            ent.spawn(level, Utils.adjustHeight(level, pos.offset(-3, 0, 3).mutable()), MobSpawnType.REINFORCEMENT);
            ent.spawn(level, Utils.adjustHeight(level, pos.offset(-3, 0, -3).mutable()), MobSpawnType.REINFORCEMENT);
            return false;
        }
        return true;
    }
}

