/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.mob;

import divinerpg.registries.BlockRegistry;
import divinerpg.registries.MobEffectRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;

public class HeavyAirEffect
extends MobEffect {
    public HeavyAirEffect() {
        super(MobEffectCategory.HARMFUL, 3223347);
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        super.onEffectAdded(entity, amplifier);
        if (entity instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)entity;
            if (s.gameMode.getGameModeForPlayer() == GameType.SURVIVAL) {
                s.setGameMode(GameType.ADVENTURE);
            }
        }
    }

    public void onMobRemoved(LivingEntity entity, int amplifier, Entity.RemovalReason reason) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)entity;
            if (s.gameMode.getGameModeForPlayer() == GameType.ADVENTURE) {
                s.setGameMode(GameType.SURVIVAL);
            }
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration == 10;
    }

    public boolean applyEffectTick(LivingEntity entity, int i) {
        if (entity.level().getBlockState(new BlockPos(entity.getBlockX(), (int)(entity.getY() + (double)entity.getEyeHeight()), entity.getBlockZ())).is(BlockRegistry.dungeonAir)) {
            entity.addEffect(new MobEffectInstance(MobEffectRegistry.HEAVY_AIR, 20, 1, true, false, false));
            return true;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)entity;
            if (s.gameMode.getGameModeForPlayer() == GameType.ADVENTURE) {
                s.setGameMode(GameType.SURVIVAL);
            }
        }
        return false;
    }
}

