/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.mob.armor.base;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import divinerpg.effect.mob.armor.ArmorEffect;
import divinerpg.effect.mob.armor.UpdatableArmorEffect;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class StepAssistEffect
extends ArmorEffect
implements UpdatableArmorEffect {
    public static final AttributeModifier STEP_MOD = new AttributeModifier(Attributes.STEP_HEIGHT.getKey().location(), 0.6, AttributeModifier.Operation.ADD_VALUE);

    public StepAssistEffect() {
        super(12540582);
    }

    public void addAttributeModifiers(AttributeMap map, int i) {
        super.addAttributeModifiers(map, i);
        AttributeInstance stepHeight = map.getInstance(Attributes.STEP_HEIGHT);
        if (stepHeight == null) {
            ArrayListMultimap attributes = ArrayListMultimap.create();
            attributes.put((Object)Attributes.STEP_HEIGHT, (Object)STEP_MOD);
            map.addTransientAttributeModifiers((Multimap)attributes);
        } else {
            stepHeight.addTransientModifier(STEP_MOD);
        }
    }

    public void removeAttributeModifiers(AttributeMap map) {
        super.removeAttributeModifiers(map);
        AttributeInstance stepHeight = map.getInstance(Attributes.STEP_HEIGHT);
        if (stepHeight != null) {
            stepHeight.removeModifier(STEP_MOD);
        }
    }

    @Override
    public void update(ResourceKey<Level> level, LivingEntity entity) {
        AttributeMap map = entity.getAttributes();
        AttributeInstance stepHeight = map.getInstance(Attributes.STEP_HEIGHT);
        if (stepHeight == null) {
            ArrayListMultimap attributes = ArrayListMultimap.create();
            attributes.put((Object)Attributes.STEP_HEIGHT, (Object)STEP_MOD);
            map.addTransientAttributeModifiers((Multimap)attributes);
        } else if (stepHeight.getModifier(STEP_MOD.id()) == null) {
            stepHeight.addTransientModifier(STEP_MOD);
        }
    }
}

