/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.mob.armor.iceika;

import divinerpg.effect.mob.armor.ArmorEffect;
import divinerpg.effect.mob.armor.ArmorEffectInstance;
import divinerpg.effect.mob.armor.UpdatableArmorEffect;
import divinerpg.registries.LevelRegistry;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SengFurEffect
extends ArmorEffect
implements UpdatableArmorEffect {
    public SengFurEffect() {
        super(3623051);
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        super.onEffectAdded(entity, amplifier);
        this.update((ResourceKey<Level>)entity.level().dimension(), entity);
    }

    public void onMobRemoved(LivingEntity entity, int amplifier, Entity.RemovalReason reason) {
        if (entity.hasEffect(MobEffects.MOVEMENT_SPEED) && entity.getEffect(MobEffects.MOVEMENT_SPEED).isInfiniteDuration()) {
            entity.removeEffect(MobEffects.MOVEMENT_SPEED);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int i) {
        ServerPlayer player;
        if (entity.level().dimension() == LevelRegistry.ICEIKA && entity instanceof ServerPlayer && (player = (ServerPlayer)entity).getFoodData().needsFood()) {
            player.getFoodData().eat(1, 0.0f);
        }
        return true;
    }

    @Override
    public void update(ResourceKey<Level> level, LivingEntity entity) {
        if (level == LevelRegistry.ICEIKA) {
            if (!entity.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                entity.addEffect((MobEffectInstance)new ArmorEffectInstance((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 1, true, false));
            }
        } else if (entity.hasEffect(MobEffects.MOVEMENT_SPEED) && entity.getEffect(MobEffects.MOVEMENT_SPEED).isInfiniteDuration()) {
            entity.removeEffect(MobEffects.MOVEMENT_SPEED);
        }
    }
}

