/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.mob.armor.vanilla;

import divinerpg.effect.mob.armor.ArmorEffect;
import divinerpg.effect.mob.armor.UpdatableArmorEffect;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class AngelicFlightEffect
extends ArmorEffect
implements UpdatableArmorEffect {
    public AngelicFlightEffect() {
        super(4088791);
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        ServerPlayer player;
        super.onEffectAdded(entity, amplifier);
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).isCreative()) {
            player.getAbilities().mayfly = true;
            player.onUpdateAbilities();
        }
    }

    public void onMobRemoved(LivingEntity entity, int amplifier, Entity.RemovalReason reason) {
        ServerPlayer player;
        super.onMobRemoved(entity, amplifier, reason);
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).isCreative()) {
            player.getAbilities().mayfly = false;
            player.getAbilities().flying = false;
            player.onUpdateAbilities();
        }
    }

    @Override
    public void update(ResourceKey<Level> level, LivingEntity entity) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).isCreative() && !player.getAbilities().mayfly) {
            player.getAbilities().mayfly = true;
            player.onUpdateAbilities();
        }
    }
}

