/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.apalachia;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityEnchantedWarrior
extends EntityDivineMonster {
    public EntityEnchantedWarrior(EntityType<? extends EntityEnchantedWarrior> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemRegistry.apalachia_blade.get()));
        super.populateDefaultEquipmentSlots(random, difficulty);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data) {
        RandomSource random = level.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(level, this.getRandom(), difficulty);
        return data;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.HISS.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }
}

