/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.entities.base.EntityDivineMerchant;
import divinerpg.registries.RecipeRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class EntityDatticon
extends EntityDivineMerchant {
    public EntityDatticon(EntityType<? extends EntityDatticon> type, Level worldIn) {
        super(type, worldIn, "datticon");
    }

    @Override
    public String[] getChatMessages() {
        return new String[]{"message.datticon.merik", "message.datticon.furnace", "message.datticon.science", "message.datticon.plugged", "message.datticon.redstone"};
    }

    protected void updateTrades() {
        this.addOffersFromItemListings(this.getOffers(), RecipeRegistry.Trades.DATTICON.get(this.level(), this.getRandom()), 5);
    }

    public static boolean rules(EntityType<? extends EntityDatticon> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.below();
        List entityList = level.getEntitiesOfClass(EntityDatticon.class, new AABB(pos).inflate(16.0));
        return spawnType == MobSpawnType.SPAWNER || level.getBlockState(blockpos).isValidSpawn((BlockGetter)level, blockpos, type) && entityList.isEmpty();
    }
}

