/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.registries.SoundRegistry;
import divinerpg.registries.TagRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EntityGolemOfRejuvenation
extends EntityDivineTameable {
    private int healTimer = 0;

    public EntityGolemOfRejuvenation(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn, 1.0f);
    }

    public void tick() {
        super.tick();
        if (this.getOwner() != null) {
            if (this.healTimer == 16) {
                this.getOwner().heal(1.0f);
                this.healTimer = 0;
            } else {
                ++this.healTimer;
            }
        }
    }

    @Override
    public boolean isFood(ItemStack item) {
        return item.is(TagRegistry.PET_FOODS_GOLEM_OF_REJUVENATION);
    }

    @Override
    protected boolean isTamingFood(ItemStack item) {
        return item.is(TagRegistry.PET_TAMING_FOODS_GOLEM_OF_REJUVENATION);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.GOLEM.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }
}

