/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.attachments.Arcana;
import divinerpg.entities.base.EntityDivineNeutral;
import divinerpg.entities.projectile.bullet.EntitySkyreBullet;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntitySkyre
extends EntityDivineNeutral {
    public EntitySkyre(EntityType<? extends EntitySkyre> type, Level worldIn) {
        super((EntityType<? extends EntityDivineNeutral>)type, worldIn);
    }

    public void tick() {
        ServerPlayer player;
        super.tick();
        if (!(this.level().isClientSide || (player = (ServerPlayer)this.level().getNearestPlayer((Entity)this, 8.0)) == null || player.isCreative() && player.isSpectator())) {
            Arcana.modifyAmount((LivingEntity)player, -1.0f);
            Arcana.modifyAmount((LivingEntity)this, 1.0f);
            if (Arcana.getAmount((LivingEntity)this) >= 200.0f) {
                Arcana.setAmount((LivingEntity)this, 0.0f);
                if (this.isAlive() && this.getTarget() != null && player.getHealth() >= 2.0f) {
                    EntitySkyreBullet entity = (EntitySkyreBullet)((EntityType)EntityRegistry.SKYRE_BULLET.get()).create(this.level());
                    entity.setOwner((Entity)player);
                    entity.setPos(player.position());
                    double d0 = this.getTarget().getX() - this.getX();
                    double d1 = this.getTarget().getY(0.3333333333333333) - entity.getY();
                    double d2 = this.getTarget().getZ() - this.getZ();
                    double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
                    entity.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 0.8f);
                    this.level().addFreshEntity((Entity)entity);
                    this.playSound((SoundEvent)SoundRegistry.SKYRE_SHOOT.get());
                }
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.SKYRE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.SKYRE_DIE.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.SKYRE_DIE.get();
    }
}

