/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.projectile.DivineThrowableProjectile;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class EntityBaseMage
extends EntityDivineMonster {
    private final Supplier<EntityType<? extends DivineThrowableProjectile>> projectileType;

    public EntityBaseMage(EntityType<? extends EntityBaseMage> type, Level worldIn, Supplier<EntityType<? extends DivineThrowableProjectile>> projectileType) {
        super(type, worldIn);
        this.projectileType = projectileType;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 19 == 0 && this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            double tx = this.getTarget().getX() - this.getX();
            double ty = this.getTarget().getBoundingBox().minY - this.getY() - 0.1;
            double tz = this.getTarget().getZ() - this.getZ();
            ThrowableProjectile e = (ThrowableProjectile)((EntityType)(this.projectileType == null ? EntityRegistry.SPELLBINDER_SHOT : this.projectileType).get()).create(this.level());
            e.setOwner((Entity)this);
            e.setPos(this.getEyePosition());
            e.shoot(tx, ty, tz, 1.6f, 0.0f);
            this.level().addFreshEntity((Entity)e);
            this.playSound((SoundEvent)SoundRegistry.MAGE_FIRE.get());
        }
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return 0.0f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.INSECT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.INSECT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.INSECT.get();
    }
}

