/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.goals.EscapeWaterGoal;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public abstract class EntityDivineFireballMob
extends EntityDivineMonster
implements RangedAttackMob {
    Integer preferredY = null;

    public EntityDivineFireballMob(EntityType<? extends EntityDivineFireballMob> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new EscapeWaterGoal((LivingEntity)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void customServerAiStep() {
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        LivingEntity target = this.getTarget();
        if (this.preferredY == null || target != null && (this.preferredY < target.getBlockY() || this.preferredY > target.getBlockY() + 3)) {
            this.preferredY = target != null && this.canAttack(target) ? Integer.valueOf(target.getBlockY() + this.random.nextInt(2)) : null;
        } else if (this.getBlockY() < this.preferredY) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, ((double)this.preferredY.intValue() - this.getY()) / 12.0 * this.getAttributeValue(Attributes.FLYING_SPEED), 0.0));
        }
    }

    public void performRangedAttack(LivingEntity entity, float f) {
        if (!this.level().isClientSide) {
            LivingEntity target = this.getTarget();
            if (this.isAlive() && target != null) {
                Fireball projectile = this.getProjectile();
                projectile.setPos(new Vec3(this.getX(), this.getEyeY(), this.getZ()));
                projectile.setOwner((Entity)this);
                projectile.shoot(target.getX() - this.getX() + this.random.nextDouble() - this.random.nextDouble(), target.getEyeY() - this.getEyeY() - this.random.nextDouble() / 2.0, target.getZ() - this.getZ() + this.random.nextDouble() - this.random.nextDouble(), 1.6f, 0.8f);
                this.level().addFreshEntity((Entity)projectile);
            }
        }
        if (this.getShootSound() != null && this.isAlive() && this.getTarget() != null) {
            this.playSound(this.getShootSound());
        }
    }

    protected abstract Fireball getProjectile();

    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.BLAZE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.BLAZE_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }
}

