/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.registries.SoundRegistry;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public abstract class EntityDivineMerchant
extends AbstractVillager {
    String profession;

    public EntityDivineMerchant(EntityType<? extends EntityDivineMerchant> type, Level level, String profession) {
        super(type, level);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.profession = profession;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractIllager.class, 15.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vex.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ravager.class, 12.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zoglin.class, 10.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.35));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.goalSelector.addGoal(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    protected void rewardTradeXp(MerchantOffer offer) {
        int i = 3 + this.random.nextInt(4);
        if (offer.shouldRewardExp()) {
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!(player.getItemInHand(hand).getItem() instanceof SpawnEggItem) && this.isAlive() && !this.isSleeping() && !player.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                boolean hasOffers;
                boolean bl = hasOffers = !this.getOffers().isEmpty();
                if (hand == InteractionHand.MAIN_HAND) {
                    player.awardStat(Stats.TALKED_TO_VILLAGER);
                    if (hasOffers && this.canTrade(player)) {
                        this.setTradingPlayer(player);
                        this.openTradingScreen(player, (Component)Component.translatable((String)("entity.divinerpg." + this.profession)), 0);
                        if (this.getChatMessages().length != 0 && this.random.nextInt(5) == 1) {
                            player.displayClientMessage((Component)Component.literal((String)(this.getName().getString() + ": ")).append((Component)Component.translatable((String)this.getChatMessages()[this.random.nextInt(this.getChatMessages().length)])), false);
                        }
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean canRestock() {
        return true;
    }

    public boolean showProgressBar() {
        return false;
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    protected void stopTrading() {
        super.stopTrading();
        this.resetSpecialPrices();
    }

    private void resetSpecialPrices() {
        if (this.level() instanceof ServerLevel) {
            for (MerchantOffer merchantoffer : this.getOffers()) {
                merchantoffer.resetSpecialPriceDiff();
            }
        }
    }

    private boolean canTrade(Player player) {
        return player.isAlive() && !player.isSleeping();
    }

    public void setTradingPlayer(@Nullable Player player) {
        if (this.getTradingPlayer() != player && player != null && this.canTrade(player)) {
            super.setTradingPlayer(player);
        }
    }

    public abstract String[] getChatMessages();

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.MERCHANT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.MERCHANT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.MERCHANT_HURT.get();
    }

    protected SoundEvent getTradeUpdatedSound(boolean isYesSound) {
        return (SoundEvent)SoundRegistry.MERCHANT.get();
    }

    public SoundEvent getNotifyTradeSound() {
        return (SoundEvent)SoundRegistry.MERCHANT.get();
    }

    public void playCelebrateSound() {
    }

    public static class DivineMapTrades
    extends DivineTrades {
        public final String displayName;
        private final TagKey<Structure> destination;
        public final Holder<MapDecorationType> destinationType;

        public DivineMapTrades(ItemStack input1, ItemStack input2, String displayName, TagKey<Structure> destination, Holder<MapDecorationType> destinationType, int xp) {
            super(input1, input2, null, 1, xp);
            this.displayName = displayName;
            this.destination = destination;
            this.destinationType = destinationType;
        }

        public DivineMapTrades(ItemStack input1, String displayName, TagKey<Structure> destination, Holder<MapDecorationType> destinationType, int xp) {
            this(input1, null, displayName, destination, destinationType, xp);
        }

        @Override
        @Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource rand) {
            ServerLevel serverlevel;
            BlockPos blockpos;
            Level level = entity.level();
            if (level instanceof ServerLevel && (blockpos = (serverlevel = (ServerLevel)level).findNearestMapStructure(this.destination, entity.blockPosition(), 100, true)) != null) {
                ItemStack itemstack = MapItem.create((Level)serverlevel, (int)blockpos.getX(), (int)blockpos.getZ(), (byte)2, (boolean)true, (boolean)true);
                MapItem.renderBiomePreviewMap((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", this.destinationType);
                itemstack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.displayName));
                return new MerchantOffer(new ItemCost((ItemLike)this.input1.getItem(), this.input1.getCount()), Optional.of(new ItemCost((ItemLike)this.input2.getItem(), this.input2.getCount())), itemstack, 1, this.xp, 0.0f);
            }
            return null;
        }
    }

    public static class DivineTrades
    implements VillagerTrades.ItemListing {
        public Component name;
        public final ItemStack input1;
        public final ItemStack input2;
        public final ItemStack output;
        protected int xp;
        protected int stock;

        public DivineTrades(ItemStack input1, ItemStack input2, ItemStack output, int stock, int xp) {
            this.xp = xp;
            this.stock = stock + 1;
            this.output = output;
            this.input1 = input1;
            this.input2 = input2;
        }

        public DivineTrades(ItemStack input1, ItemStack output, int stock, int xp) {
            this(input1, null, output, stock, xp);
        }

        public MerchantOffer getOffer(Entity tradeEnt, RandomSource rand) {
            if (this.input2 != null) {
                return new MerchantOffer(new ItemCost((ItemLike)this.input1.getItem(), this.input1.getCount()), Optional.of(new ItemCost((ItemLike)this.input2.getItem(), this.input2.getCount())), this.output, this.stock, this.xp, 0.0f);
            }
            return new MerchantOffer(new ItemCost((ItemLike)this.input1.getItem(), this.input1.getCount()), this.output, this.stock, this.xp, 0.0f);
        }
    }
}

