/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.registries.AttachmentRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;

public class EntityDivineTameable
extends TamableAnimal
implements NeutralMob {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    protected final float healthIncrease;
    private UUID angry_at;

    protected EntityDivineTameable(EntityType<? extends TamableAnimal> type, Level worldIn, float healthIncrease) {
        super(type, worldIn);
        this.healthIncrease = healthIncrease;
        this.setTame(false, false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EntityDivineTameable)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        if (!this.level().isClientSide) {
            this.setOrderedToSit(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.hurt(source, amount);
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(this.getMaxHealth() * this.healthIncrease));
            this.setHealth(this.getMaxHealth());
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)this.getMaxHealth());
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.level().isClientSide) {
            AttachmentRegistry.COLOR.requestAttachment((Entity)this, null);
            AttachmentRegistry.ANGRY.requestAttachment((Entity)this, null);
        }
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId((int)((Integer)AttachmentRegistry.COLOR.get((Entity)this)));
    }

    public void setCollarColor(DyeColor color) {
        AttachmentRegistry.COLOR.set((Entity)this, color.getId());
    }

    public boolean isMeat(ItemStack stack) {
        return stack.is(ItemTags.MEAT);
    }

    public boolean isFood(ItemStack item) {
        return this.isMeat(item);
    }

    protected boolean isTamingFood(ItemStack item) {
        return this.isMeat(item);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (!this.level().isClientSide || this.isBaby() && this.isFood(itemstack)) {
            if (this.isTame()) {
                InteractionResult interactionresult;
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(2.0f * f);
                    itemstack.consume(1, (LivingEntity)player);
                    this.gameEvent((Holder)GameEvent.EAT, (Entity)this);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                if (item instanceof DyeItem) {
                    DyeItem dyeitem = (DyeItem)item;
                    if (this.isOwnedBy((LivingEntity)player)) {
                        DyeColor dyecolor = dyeitem.getDyeColor();
                        if (dyecolor != this.getCollarColor()) {
                            this.setCollarColor(dyecolor);
                            itemstack.consume(1, (LivingEntity)player);
                            return InteractionResult.SUCCESS;
                        }
                        return super.mobInteract(player, hand);
                    }
                }
                if (!(interactionresult = super.mobInteract(player, hand)).consumesAction() && this.isOwnedBy((LivingEntity)player)) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    this.jumping = false;
                    this.navigation.stop();
                    this.setTarget(null);
                    return InteractionResult.SUCCESS_NO_ITEM_USED;
                }
                return interactionresult;
            }
            if (this.isTamingFood(itemstack) && !this.isAngry() && !player.isCreative()) {
                itemstack.consume(1, (LivingEntity)player);
                if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                    this.tame(player);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.setOrderedToSit(true);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.isCreative()) {
                this.tame(player);
            }
            return super.mobInteract(player, hand);
        }
        boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame() || this.isTamingFood(itemstack) && !this.isTame() && !this.isAngry();
        return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    public void tame(Player player) {
        super.tame(player);
        this.setCollarColor(DyeColor.RED);
    }

    public boolean wantsToAttack(LivingEntity entity, LivingEntity entity1) {
        if (!(entity instanceof Creeper) && !(entity instanceof Ghast)) {
            boolean bl;
            LivingEntity livingEntity = entity;
            Objects.requireNonNull(livingEntity);
            LivingEntity livingEntity2 = livingEntity;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityDivineTameable.class, Player.class, AbstractHorse.class}, (Object)livingEntity2, n)) {
                    case 0: {
                        EntityDivineTameable pet = (EntityDivineTameable)livingEntity2;
                        if (!pet.isTame() || pet.getOwner() != entity1) {
                            bl = true;
                            break block5;
                        }
                        bl = false;
                        break block5;
                    }
                    case 1: {
                        Player player = (Player)livingEntity2;
                        if (!(entity1 instanceof Player) || ((Player)entity1).canHarmPlayer(player)) {
                            n = 2;
                            continue block5;
                        }
                        bl = false;
                        break block5;
                    }
                    case 2: {
                        AbstractHorse abstractHorse = (AbstractHorse)livingEntity2;
                        if (!abstractHorse.isTamed()) {
                            n = 3;
                            continue block5;
                        }
                        bl = false;
                        break block5;
                    }
                    default: {
                        if (!(entity instanceof TamableAnimal) || !((TamableAnimal)entity).isTame()) {
                            bl = true;
                            break block5;
                        }
                        bl = false;
                        break block5;
                    }
                }
                break;
            }
            return bl;
        }
        return false;
    }

    public boolean canBeLeashed() {
        return !this.isAngry() && super.canBeLeashed();
    }

    public int getRemainingPersistentAngerTime() {
        return AttachmentRegistry.ANGER_TIME.get((Entity)this);
    }

    public void setRemainingPersistentAngerTime(int i) {
        AttachmentRegistry.ANGER_TIME.set((Entity)this, i);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        if (((Boolean)AttachmentRegistry.ANGRY.get((Entity)this)).booleanValue()) {
            return this.angry_at;
        }
        return null;
    }

    public boolean isAngry() {
        return (Boolean)AttachmentRegistry.ANGRY.get((Entity)this);
    }

    public void setPersistentAngerTarget(@Nullable UUID id) {
        this.angry_at = id;
        AttachmentRegistry.ANGRY.set((Entity)this, id != null);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("angryAt")) {
            this.angry_at = compound.getUUID("angryAt");
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        UUID angry_at = this.getPersistentAngerTarget();
        if (angry_at != null) {
            compound.putUUID("angryAt", angry_at);
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel s, AgeableMob a) {
        return null;
    }

    public boolean canMate(Animal animal) {
        return false;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }
}

