/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public abstract class EntityGifterNPC
extends PathfinderMob {
    public EntityGifterNPC(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.35));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType type) {
        return true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive()) {
            if (!this.level().isClientSide) {
                player.getInventory().add(this.getGift());
                if (this.getChatMessages().length != 0 && this.random.nextInt(5) == 1) {
                    player.displayClientMessage((Component)Component.literal((String)(this.getName().getString() + ": ")).append((Component)Component.translatable((String)this.getChatMessages()[this.random.nextInt(this.getChatMessages().length)])), false);
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    protected abstract ItemStack getGift();

    public abstract String[] getChatMessages();
}

