/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.SoundRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityAyeraco
extends EntityDivineBoss {
    public BlockPos beam;
    private Vec3 moveTargetPoint = Vec3.ZERO;
    private boolean circling = true;
    private BlockPos anchorPoint = BlockPos.ZERO;

    public EntityAyeraco(EntityType<? extends EntityAyeraco> type, Level level) {
        this(type, level, BlockPos.ZERO, 0);
    }

    public EntityAyeraco(EntityType<? extends EntityAyeraco> type, Level worldIn, BlockPos beam, byte variant) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
        this.beam = beam;
        this.moveControl = new AyeracoMoveControl((Mob)this);
        this.lookControl = new AyeracoLookControl((Mob)this);
        if (!worldIn.isClientSide()) {
            AttachmentRegistry.VARIANT.setSilent((Entity)this, variant);
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.level().isClientSide()) {
            AttachmentRegistry.VARIANT.requestAttachment((Entity)this, null);
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new AyeracoBodyRotationControl((Mob)this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new AyeracoAttackStrategyGoal());
        this.goalSelector.addGoal(2, (Goal)new AyeracoSweepAttackGoal());
        this.goalSelector.addGoal(3, (Goal)new AyeracoCircleAroundAnchorGoal());
        this.targetSelector.addGoal(1, (Goal)new AyeracoAttackPlayerTargetGoal());
    }

    public void die(DamageSource source) {
        super.die(source);
        if (this.level().isLoaded(this.beam)) {
            this.level().setBlock(this.beam, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || (source.is(DamageTypes.MOB_PROJECTILE) || source.is(DamageTypes.ARROW) || source.is(DamageTypes.TRIDENT)) && this.isProjectileProtected() || (source.is(DamageTypes.MAGIC) || source.is(DamageTypes.DRAGON_BREATH) || source.is(DamageTypes.INDIRECT_MAGIC)) && this.isMagicProtected();
    }

    public static List<EntityAyeraco> getNearbyAyeracos(Level level, Vec3 pos) {
        return level.getEntitiesOfClass(EntityAyeraco.class, new AABB(pos.x - 32.0, pos.y - 32.0, pos.z - 32.0, pos.x + 32.0, pos.y + 32.0, pos.z + 32.0));
    }

    public boolean isProjectileProtected() {
        for (EntityAyeraco e : EntityAyeraco.getNearbyAyeracos(this.level(), this.position())) {
            if (!e.isGreen()) continue;
            return true;
        }
        return false;
    }

    public boolean isMagicProtected() {
        for (EntityAyeraco e : EntityAyeraco.getNearbyAyeracos(this.level(), this.position())) {
            if (!e.isPink()) continue;
            return true;
        }
        return false;
    }

    public boolean isGreen() {
        return (Byte)AttachmentRegistry.VARIANT.get((Entity)this) == 1;
    }

    public boolean isPink() {
        return (Byte)AttachmentRegistry.VARIANT.get((Entity)this) == 2;
    }

    public boolean isPurple() {
        return (Byte)AttachmentRegistry.VARIANT.get((Entity)this) == 3;
    }

    public boolean isRed() {
        return (Byte)AttachmentRegistry.VARIANT.get((Entity)this) == 4;
    }

    public boolean isYellow() {
        return (Byte)AttachmentRegistry.VARIANT.get((Entity)this) == 5;
    }

    public boolean isBlue() {
        return (Byte)AttachmentRegistry.VARIANT.get((Entity)this) == 6;
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean b = super.hurt(source, amount);
        if (!this.level().isClientSide() && this.isAlive()) {
            byte variant = this.getVariant();
            boolean isRed = variant == 4;
            boolean isYellow = variant == 5;
            boolean isBlue = variant == 6;
            for (EntityAyeraco e : EntityAyeraco.getNearbyAyeracos(this.level(), this.position())) {
                if (isRed && e != this && e.getHealth() < e.getMaxHealth()) {
                    e.setHealth(e.getMaxHealth());
                }
                if (isYellow) {
                    e.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 255, 2, true, false, false));
                }
                if (isBlue) {
                    e.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 255, 2, true, false, false));
                }
                if (!e.isPurple()) continue;
                this.playSound((SoundEvent)SoundRegistry.AYERACO_TELEPORT.get(), 2.0f, 0.4f / (this.random.nextFloat() * 0.4f + 0.8f));
                this.teleportRelative(this.random.nextInt(5) - 2, 3 + this.random.nextInt(15), this.random.nextInt(5) - 2);
            }
        }
        return b;
    }

    public byte getVariant() {
        byte variant = (Byte)AttachmentRegistry.VARIANT.get((Entity)this);
        if (variant == 0 && this.beam != null) {
            BlockState block = this.level().getBlockState(this.beam);
            if (block.is((Block)BlockRegistry.ayeracoBeamBlue.get())) {
                return 6;
            }
            if (block.is((Block)BlockRegistry.ayeracoBeamGreen.get())) {
                return 1;
            }
            if (block.is((Block)BlockRegistry.ayeracoBeamPink.get())) {
                return 2;
            }
            if (block.is((Block)BlockRegistry.ayeracoBeamPurple.get())) {
                return 3;
            }
            if (block.is((Block)BlockRegistry.ayeracoBeamRed.get())) {
                return 4;
            }
            if (block.is((Block)BlockRegistry.ayeracoBeamYellow.get())) {
                return 5;
            }
        }
        return variant;
    }

    public boolean hasCustomName() {
        return false;
    }

    public EntityAyeraco setVariant(byte variant) {
        AttachmentRegistry.VARIANT.set((Entity)this, variant == 0 ? (byte)6 : (byte)variant);
        MutableComponent component = Component.translatable((String)(switch (variant) {
            case 1 -> "entity.divinerpg.green_ayeraco";
            case 2 -> "entity.divinerpg.pink_ayeraco";
            case 3 -> "entity.divinerpg.purple_ayeraco";
            case 4 -> "entity.divinerpg.red_ayeraco";
            case 5 -> "entity.divinerpg.yellow_ayeraco";
            default -> "entity.divinerpg.blue_ayeraco";
        }));
        this.setCustomName((Component)component);
        return this;
    }

    public void setBeamPos(BlockPos pos) {
        this.beam = pos;
    }

    protected void checkFallDamage(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.AYERACO.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.AYERACO_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.AYERACO_HURT.get();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putLong("Beam", this.beam.asLong());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.beam = BlockPos.of((long)tag.getLong("Beam"));
    }

    public void travel(Vec3 vec) {
        if (this.isInWater() || this.isInLava()) {
            this.moveRelative(0.02f, vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
        } else {
            BlockPos ground = new BlockPos((Vec3i)this.blockPosition().below());
            float f = 0.91f;
            if (this.onGround()) {
                f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.onGround()) {
                f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
            }
            this.moveRelative(this.onGround() ? 0.1f * f1 : 0.02f, vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)f));
        }
        this.calculateEntityAnimation(false);
    }

    class AyeracoMoveControl
    extends MoveControl {
        private float speed;

        public AyeracoMoveControl(Mob mob) {
            super(mob);
            this.speed = 0.2f;
        }

        public void tick() {
            if (EntityAyeraco.this.horizontalCollision) {
                EntityAyeraco.this.setYRot(EntityAyeraco.this.getYRot() + 180.0f);
                this.speed = 0.2f;
            }
            double d0 = EntityAyeraco.this.moveTargetPoint.x - EntityAyeraco.this.getX();
            double d1 = EntityAyeraco.this.moveTargetPoint.y - EntityAyeraco.this.getY();
            double d2 = EntityAyeraco.this.moveTargetPoint.z - EntityAyeraco.this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > 1.0E-5) {
                double d4 = 1.0 - Math.abs(d1 * 0.7) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = EntityAyeraco.this.getYRot();
                float f1 = (float)Mth.atan2((double)d2, (double)d0);
                float f2 = Mth.wrapDegrees((float)(EntityAyeraco.this.getYRot() + 90.0f));
                float f3 = Mth.wrapDegrees((float)(f1 * 57.295776f));
                EntityAyeraco.this.setYRot(Mth.approachDegrees((float)f2, (float)f3, (float)4.0f) - 90.0f);
                EntityAyeraco.this.yBodyRot = EntityAyeraco.this.getYRot();
                this.speed = Mth.degreesDifferenceAbs((float)f, (float)EntityAyeraco.this.getYRot()) < 3.0f ? Mth.approach((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.approach((float)this.speed, (float)0.22f, (float)0.025f);
                float f4 = (float)(-(Mth.atan2((double)(-d1), (double)d3) * 57.2957763671875));
                EntityAyeraco.this.setXRot(f4);
                float f5 = EntityAyeraco.this.getYRot() + 90.0f;
                double d6 = (double)(this.speed * Mth.cos((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.sin((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.sin((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = EntityAyeraco.this.getDeltaMovement();
                EntityAyeraco.this.setDeltaMovement(vec3.add(new Vec3(d6, d8, d7).subtract(vec3).scale(0.2)));
            }
        }
    }

    static class AyeracoLookControl
    extends LookControl {
        public AyeracoLookControl(Mob mob) {
            super(mob);
        }

        public void tick() {
        }
    }

    class AyeracoBodyRotationControl
    extends BodyRotationControl {
        public AyeracoBodyRotationControl(Mob mob) {
            super(mob);
        }

        public void clientTick() {
            EntityAyeraco.this.yHeadRot = EntityAyeraco.this.yBodyRot;
            EntityAyeraco.this.yBodyRot = EntityAyeraco.this.getYRot();
        }
    }

    class AyeracoAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        AyeracoAttackStrategyGoal() {
        }

        public boolean canUse() {
            LivingEntity livingentity = EntityAyeraco.this.getTarget();
            return livingentity != null && EntityAyeraco.this.canAttack(livingentity, TargetingConditions.DEFAULT);
        }

        public void start() {
            this.nextSweepTick = this.adjustedTickDelay(10);
            EntityAyeraco.this.circling = true;
            this.setAnchorAboveTarget();
        }

        public void stop() {
            EntityAyeraco.this.anchorPoint = EntityAyeraco.this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, EntityAyeraco.this.anchorPoint).above(10 + EntityAyeraco.this.random.nextInt(20));
        }

        public void tick() {
            if (EntityAyeraco.this.circling) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    EntityAyeraco.this.circling = false;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.adjustedTickDelay((8 + EntityAyeraco.this.random.nextInt(4)) * 20);
                    EntityAyeraco.this.playSound((SoundEvent)SoundRegistry.AYERACO_TELEPORT.get(), 10.0f, 0.95f + EntityAyeraco.this.random.nextFloat() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            EntityAyeraco.this.anchorPoint = EntityAyeraco.this.getTarget().blockPosition().above(20 + EntityAyeraco.this.random.nextInt(20));
            if (EntityAyeraco.this.anchorPoint.getY() < EntityAyeraco.this.level().getSeaLevel()) {
                EntityAyeraco.this.anchorPoint = new BlockPos(EntityAyeraco.this.anchorPoint.getX(), EntityAyeraco.this.level().getSeaLevel() + 1, EntityAyeraco.this.anchorPoint.getZ());
            }
        }
    }

    class AyeracoSweepAttackGoal
    extends AyeracoMoveTargetGoal {
        AyeracoSweepAttackGoal() {
        }

        public boolean canUse() {
            return EntityAyeraco.this.getTarget() != null && !EntityAyeraco.this.circling;
        }

        public boolean canContinueToUse() {
            Player player;
            LivingEntity livingentity = EntityAyeraco.this.getTarget();
            if (livingentity == null || !livingentity.isAlive()) {
                return false;
            }
            if (livingentity instanceof Player && ((player = (Player)livingentity).isSpectator() || player.isCreative())) {
                return false;
            }
            return this.canUse();
        }

        public void start() {
        }

        public void stop() {
            EntityAyeraco.this.setTarget(null);
            EntityAyeraco.this.circling = true;
        }

        public void tick() {
            LivingEntity livingentity = EntityAyeraco.this.getTarget();
            if (livingentity != null) {
                EntityAyeraco.this.moveTargetPoint = new Vec3(livingentity.getX(), livingentity.getY(0.5), livingentity.getZ());
                if (EntityAyeraco.this.getBoundingBox().inflate(0.2).intersects(livingentity.getBoundingBox())) {
                    EntityAyeraco.this.doHurtTarget((Entity)livingentity);
                    EntityAyeraco.this.circling = true;
                    if (!EntityAyeraco.this.isSilent()) {
                        EntityAyeraco.this.level().levelEvent(1039, EntityAyeraco.this.blockPosition(), 0);
                    }
                } else if (EntityAyeraco.this.horizontalCollision || EntityAyeraco.this.hurtTime > 0) {
                    EntityAyeraco.this.circling = true;
                }
            }
        }
    }

    class AyeracoCircleAroundAnchorGoal
    extends AyeracoMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        AyeracoCircleAroundAnchorGoal() {
        }

        public boolean canUse() {
            return EntityAyeraco.this.getTarget() == null || EntityAyeraco.this.circling;
        }

        public void start() {
            this.distance = 5.0f + EntityAyeraco.this.random.nextFloat() * 10.0f;
            this.height = -4.0f + EntityAyeraco.this.random.nextFloat() * 9.0f;
            this.clockwise = EntityAyeraco.this.random.nextBoolean() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void tick() {
            if (EntityAyeraco.this.random.nextInt(this.adjustedTickDelay(350)) == 0) {
                this.height = -4.0f + EntityAyeraco.this.random.nextFloat() * 9.0f;
            }
            if (EntityAyeraco.this.random.nextInt(this.adjustedTickDelay(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (EntityAyeraco.this.random.nextInt(this.adjustedTickDelay(450)) == 0) {
                this.angle = EntityAyeraco.this.random.nextFloat() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (EntityAyeraco.this.moveTargetPoint.y < EntityAyeraco.this.getY() && !EntityAyeraco.this.level().isEmptyBlock(EntityAyeraco.this.blockPosition().below(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (EntityAyeraco.this.moveTargetPoint.y > EntityAyeraco.this.getY() && !EntityAyeraco.this.level().isEmptyBlock(EntityAyeraco.this.blockPosition().above(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.ZERO.equals((Object)EntityAyeraco.this.anchorPoint)) {
                EntityAyeraco.this.anchorPoint = EntityAyeraco.this.blockPosition();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            EntityAyeraco.this.moveTargetPoint = Vec3.atLowerCornerOf((Vec3i)EntityAyeraco.this.anchorPoint).add((double)(this.distance * Mth.cos((float)this.angle)), -4.0 + (double)this.height, (double)(this.distance * Mth.sin((float)this.angle)));
        }
    }

    class AyeracoAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);
        private int nextScanTick = AyeracoAttackPlayerTargetGoal.reducedTickDelay((int)20);

        AyeracoAttackPlayerTargetGoal() {
        }

        public boolean canUse() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
            } else {
                this.nextScanTick = AyeracoAttackPlayerTargetGoal.reducedTickDelay((int)60);
                List list = EntityAyeraco.this.level().getNearbyPlayers(this.attackTargeting, (LivingEntity)EntityAyeraco.this, EntityAyeraco.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
                if (!list.isEmpty()) {
                    list.sort(Comparator.comparing(Entity::getY).reversed());
                    for (Player player : list) {
                        if (!EntityAyeraco.this.canAttack((LivingEntity)player, TargetingConditions.DEFAULT)) continue;
                        EntityAyeraco.this.setTarget((LivingEntity)player);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = EntityAyeraco.this.getTarget();
            return livingentity != null && EntityAyeraco.this.canAttack(livingentity, TargetingConditions.DEFAULT);
        }
    }

    abstract class AyeracoMoveTargetGoal
    extends Goal {
        public AyeracoMoveTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return EntityAyeraco.this.moveTargetPoint.distanceToSqr(EntityAyeraco.this.getX(), EntityAyeraco.this.getY(), EntityAyeraco.this.getZ()) < 4.0;
        }
    }
}

