/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.arrows.FuryArrow;
import divinerpg.registries.ItemRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityEternalArcher
extends EntityDivineBoss {
    private int armSelected;
    private int abilityTick;

    public EntityEternalArcher(EntityType<? extends EntityEternalArcher> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 80.0f));
    }

    public void tick() {
        super.tick();
        if (this.getTarget() != null) {
            this.getLookControl().setLookAt(this.getTarget().getX(), this.getTarget().getY() + (double)this.getTarget().getEyeHeight(), this.getTarget().getZ(), 10.0f, 5.0f);
        }
        if (this.getTarget() == null || this.random.nextInt(200) == 0) {
            this.setTarget((LivingEntity)this.level().getNearestPlayer((Entity)this, 48.0));
        }
        if (this.getTarget() != null && (this.getTarget() instanceof Player && ((Player)this.getTarget()).isCreative() || !this.getTarget().isAlive())) {
            this.setTarget(null);
        }
        if (this.abilityTick > 0) {
            --this.abilityTick;
        }
        if (this.abilityTick == 0) {
            if (this.armSelected < 5) {
                ++this.armSelected;
            } else if (this.armSelected == 5) {
                this.armSelected = 0;
            }
            this.abilityTick = 400;
        }
        if (this.abilityTick % 20 == 0 && this.getTarget() != null && !this.level().isClientSide && this.getTarget() != null) {
            LivingEntity target = this.getTarget();
            if (this.isAlive() && target != null) {
                FuryArrow abstractarrow = new FuryArrow(this.level(), (LivingEntity)this, new ItemStack((ItemLike)ItemRegistry.fury_arrow.get()), new ItemStack((ItemLike)ItemRegistry.apalachia_bow.get()));
                abstractarrow.powerMultiplier = 2.0f;
                abstractarrow.igniteForTicks(0x3FFFFFFF);
                double d0 = target.getX() - this.getX();
                double d1 = target.getY(0.3333333333333333) - abstractarrow.getY();
                double d2 = target.getZ() - this.getZ();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                abstractarrow.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 14.0f - (float)(this.level().getDifficulty().getId() << 2));
                this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                this.level().addFreshEntity((Entity)abstractarrow);
            }
        }
    }

    public int getSelectedArm() {
        return this.armSelected;
    }
}

