/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;

public class EntityRaglok
extends EntityDivineBoss {
    private int ability;
    private static final int DEFAULT = 0;
    private static final int LIGHTNING = 1;
    private static final int BLIND = 2;
    private static final int BOMBS = 3;
    private static final int SLOW = 4;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private int abilityCooldown;
    private boolean loaded = false;
    private int rangedAttackCounter;
    private boolean avengeAbilityUsed = false;

    public EntityRaglok(EntityType<? extends EntityRaglok> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    public void tick() {
        super.tick();
        if (!this.loaded && !this.level().isClientSide) {
            List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().expandTowards(30.0, 30.0, 30.0));
            for (Player p : players) {
                p.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.raglok.dare", new Object[0]), true);
            }
            this.playSound((SoundEvent)SoundRegistry.RAGLOK_AWAKEN.get(), 1.0f, 1.0f);
            this.loaded = true;
        }
        if (this.isAlive()) {
            this.manageAbilities();
        }
    }

    public void manageAbilities() {
        Player player = this.level().getNearestPlayer((Entity)this, 64.0);
        if (player == null || player.isCreative() || this.avengeAbilityUsed) {
            return;
        }
        if (this.abilityCooldown == 0 || this.ability == 0) {
            this.abilityCooldown = 400;
            switch (this.random.nextInt(4)) {
                case 0: {
                    this.ability = 1;
                    this.rangedAttackCounter = 0;
                    this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                    break;
                }
                case 1: {
                    this.ability = 2;
                    this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.3);
                    break;
                }
                case 2: {
                    this.ability = 3;
                    this.rangedAttackCounter = 0;
                    this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.3);
                    break;
                }
                case 3: {
                    this.ability = 4;
                    this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.3);
                    break;
                }
            }
            this.message();
        } else if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == 2 && player != null) {
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 25, 1));
        }
        if (this.ability == 4 && player != null) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10, 1));
        }
        if (this.ability == 1) {
            if (this.abilityCooldown % 40 == 0 && player != null) {
                LightningBolt ent = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
                ent.setPos(this.prevPlayerX, this.prevPlayerY, this.prevPlayerZ);
                this.level().addFreshEntity((Entity)ent);
                ++this.rangedAttackCounter;
            } else if (this.abilityCooldown % 40 != 0 && this.abilityCooldown % 20 == 0 && player != null) {
                this.prevPlayerX = player.getX();
                this.prevPlayerY = player.getY();
                this.prevPlayerZ = player.getZ();
            }
            if (this.rangedAttackCounter == 10) {
                this.ability = 0;
            }
        }
        if (this.ability == 3) {
            if (this.abilityCooldown % 30 == 0 && player != null) {
                for (int i = 0; i < 4; ++i) {
                    ThrowableProjectile var2 = (ThrowableProjectile)((EntityType)EntityRegistry.RAGLOK_BOMB.get()).create(this.level());
                    var2.setOwner((Entity)this);
                    var2.moveTo(player.xo, player.yo + 5.0, player.zo);
                    var2.setDeltaMovement((this.random.nextDouble() - this.random.nextDouble()) / 5.0, -0.14, (this.random.nextDouble() - this.random.nextDouble()) / 5.0);
                    this.level().addFreshEntity((Entity)var2);
                    ++this.rangedAttackCounter;
                }
            }
            if (this.rangedAttackCounter == 12) {
                this.ability = 0;
            }
        }
    }

    private void message() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(64.0, 64.0, 64.0));
        for (Entity entity : list) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            switch (this.ability) {
                case 1: {
                    this.playSound((SoundEvent)SoundRegistry.RAGLOK_GUARDIAN.get(), 1.0f, 1.0f);
                    if (this.level().isClientSide()) break;
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.raglok.think", new Object[0]), true);
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.raglok.great", new Object[0]), true);
                    break;
                }
                case 2: {
                    this.playSound((SoundEvent)SoundRegistry.RAGLOK_DARK.get(), 1.0f, 1.0f);
                    if (this.level().isClientSide()) break;
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.raglok.future", new Object[0]), true);
                    break;
                }
                case 3: {
                    this.playSound((SoundEvent)SoundRegistry.RAGLOK_RAIN.get(), 1.0f, 1.0f);
                    if (this.level().isClientSide()) break;
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.raglok.rain", new Object[0]), true);
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.raglok.kill", new Object[0]), true);
                    break;
                }
                case 4: {
                    this.playSound((SoundEvent)SoundRegistry.RAGLOK_NOTHING.get(), 1.0f, 1.0f);
                    if (this.level().isClientSide()) break;
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.raglok.compare", new Object[0]), true);
                    break;
                }
            }
        }
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.goalSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.goalSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return super.getAmbientSound();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.RAGLOK_AVENGE.get();
    }

    public void die(DamageSource source) {
        if (!this.avengeAbilityUsed) {
            Player player;
            if (!this.level().isClientSide()) {
                List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().expandTowards(30.0, 30.0, 30.0));
                for (Player p : players) {
                    p.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.raglok.avenge", new Object[0]), true);
                }
            }
            if ((player = this.level().getNearestPlayer((Entity)this, 64.0)) != null && !player.isCreative()) {
                LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
                bolt.setPos(player.position().x, player.position().y, player.position().z);
                this.level().addFreshEntity((Entity)bolt);
            }
            this.avengeAbilityUsed = true;
        }
        super.die(source);
    }
}

