/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.magic.EntityTwilightDemonShot;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntityTwilightDemon
extends EntityDivineBoss {
    int shooting;

    public EntityTwilightDemon(EntityType<? extends EntityTwilightDemon> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.tickCount % 160 == 0) {
                this.shooting = 100;
            }
            if (this.getTarget() != null && this.shooting > 0) {
                double tx = this.getTarget().getX() - this.getX();
                double ty = this.getTarget().getBoundingBox().minY - this.getY() - 2.0;
                double tz = this.getTarget().getZ() - this.getZ();
                double angle = Math.atan(-tx / tz);
                EntityTwilightDemonShot e = (EntityTwilightDemonShot)((EntityType)EntityRegistry.TWILIGHT_DEMON_SHOT.get()).create(this.level());
                e.setOwner((Entity)this);
                e.setPos(this.getEyePosition());
                if (this.random.nextBoolean()) {
                    e.particle = () -> ParticleRegistry.TWILIGHT_PORTAL.value();
                }
                e.zo += Math.sin(angle);
                e.xo += Math.cos(angle);
                e.shoot(tx - Math.cos(angle), ty, tz - Math.sin(angle), 1.6f, 0.0f);
                this.level().addFreshEntity((Entity)e);
                e = (EntityTwilightDemonShot)((EntityType)EntityRegistry.TWILIGHT_DEMON_SHOT.get()).create(this.level());
                e.setOwner((Entity)this);
                e.setPos(this.getEyePosition());
                if (this.random.nextBoolean()) {
                    e.particle = () -> ParticleRegistry.TWILIGHT_PORTAL.value();
                }
                e.zo -= Math.sin(angle);
                e.xo -= Math.cos(angle);
                e.shoot(tx + Math.cos(angle), ty, tz + Math.sin(angle), 1.6f, 0.0f);
                this.level().addFreshEntity((Entity)e);
            }
            if (this.shooting > 0) {
                --this.shooting;
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.INSECT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.INSECT.get();
    }
}

