/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.eden;

import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.registries.TagRegistry;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EntityGlinthop
extends EntityDivineTameable {
    public EntityGlinthop(EntityType<? extends EntityGlinthop> type, Level worldIn) {
        super(type, worldIn, 1.5f);
        if (!worldIn.isClientSide) {
            this.setData((Supplier)AttachmentRegistry.SPECIAL.attachment, this.random.nextInt(50) == 1);
        }
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.level().isClientSide) {
            AttachmentRegistry.SPECIAL.requestAttachment((Entity)this, null);
        }
    }

    public void die(DamageSource source) {
        super.die(source);
        if (!(this.level().isClientSide || this.isTame() || this.level().getDifficulty().equals((Object)Difficulty.PEACEFUL))) {
            this.transform();
        }
    }

    private void transform() {
        ((EntityType)EntityRegistry.ANGRY_GLINTHOP.get()).spawn((ServerLevel)this.level(), ItemStack.EMPTY, null, this.blockPosition(), MobSpawnType.MOB_SUMMONED, true, false);
        this.remove(Entity.RemovalReason.KILLED);
    }

    public void setTarget(LivingEntity e) {
        super.setTarget(e);
        if (this.isTame()) {
            AttachmentRegistry.ANGRY.set((Entity)this, e != null);
        }
    }

    public boolean isSpecialAlt() {
        return (Boolean)AttachmentRegistry.SPECIAL.get((Entity)this);
    }

    @Nullable
    public LivingEntity getTarget() {
        LivingEntity entity = super.getTarget();
        if (entity != null && (this.isTame() && this.distanceToSqr((Entity)entity) < 144.0 || !this.isTame())) {
            return entity;
        }
        return null;
    }

    @Override
    public boolean isFood(ItemStack item) {
        return item.is(TagRegistry.PET_FOODS_GLINTHOP);
    }

    @Override
    protected boolean isTamingFood(ItemStack item) {
        return item.is(TagRegistry.PET_TAMING_FOODS_GLINTHOP);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.GLINTHOP.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.GLINTHOP_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.GLINTHOP_HURT.get();
    }
}

