/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.eden;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class EntityMadivel
extends EntityDivineMonster {
    private int attackAnimationTick;

    public EntityMadivel(EntityType<? extends EntityMadivel> type, Level worldIn) {
        super(type, worldIn);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public boolean doHurtTarget(Entity entity) {
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(entity);
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.attackAnimationTick = 10;
        }
        super.handleEntityEvent(id);
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.MADIVEL.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.MADIVEL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.MADIVEL_HURT.get();
    }
}

