/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals;

import divinerpg.entities.base.FactionEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class FactionTargetGoal<T extends LivingEntity>
extends TargetGoal {
    public static final int DEFAULT_RANDOM_INTERVAL = 10;
    @Nullable
    protected LivingEntity target;
    protected final int randomInterval;
    public final FactionEntity.Faction myFaction;
    protected TargetingConditions targetConditions;

    public FactionTargetGoal(Mob mob, FactionEntity.Faction faction, boolean mustSee, boolean mustReach) {
        this(mob, faction, mustSee, mustReach, 10);
    }

    public FactionTargetGoal(Mob mob, FactionEntity.Faction faction, boolean mustSee, boolean mustReach, int interval) {
        super(mob, mustSee, mustReach);
        this.myFaction = faction;
        this.randomInterval = FactionTargetGoal.reducedTickDelay((int)interval);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.forCombat().range(this.getFollowDistance());
    }

    public boolean canUse() {
        if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected void findTarget() {
        this.target = FactionEntity.Faction.getNearestEnemy((LivingEntity)this.mob, this.getTargetSearchArea(this.getFollowDistance()), this.targetConditions);
    }

    protected AABB getTargetSearchArea(double distance) {
        return this.mob.getBoundingBox().inflate(distance, distance / 2.0, distance);
    }

    public void start() {
        this.mob.setTarget(this.target);
        super.start();
    }

    public void setTarget(@Nullable LivingEntity entity) {
        this.target = entity;
    }
}

