/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class SunstormAttackGoal
extends Goal {
    private final Mob entityHost;
    private final RangedAttackMob rangedAttackEntityHost;
    private LivingEntity attackTarget;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;

    public SunstormAttackGoal(RangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
        this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
    }

    public SunstormAttackGoal(RangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
        if (!(attacker instanceof Mob)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = attacker;
        this.entityHost = (Mob)attacker;
        this.entityMoveSpeed = movespeed;
        this.attackIntervalMin = p_i1650_4_;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
    }

    public boolean shouldExecute() {
        LivingEntity entitylivingbase = this.entityHost.getTarget();
        if (entitylivingbase == null) {
            return false;
        }
        double distance = this.entityHost.distanceToSqr(entitylivingbase.xo, entitylivingbase.getBoundingBox().minY, entitylivingbase.zo);
        if (distance < 4.0 || entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean canUse() {
        return this.shouldExecute() || !this.entityHost.getNavigation().isDone();
    }

    public boolean canContinueToUse() {
        return this.shouldExecute() || !this.entityHost.getNavigation().isDone();
    }

    public void stop() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void tick() {
        if (this.entityHost != null && this.attackTarget != null) {
            double d0 = this.entityHost.distanceToSqr(this.attackTarget.xo, this.attackTarget.getBoundingBox().minY, this.attackTarget.zo);
            boolean flag = this.entityHost.hasLineOfSight((Entity)this.attackTarget);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entityHost.getNavigation().stop();
            } else {
                this.entityHost.getNavigation().moveTo((Entity)this.attackTarget, this.entityMoveSpeed);
            }
            this.entityHost.getLookControl().setLookAt((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = Mth.sqrt((float)((float)d0)) / this.attackRadius;
                float lvt_5_1_ = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackEntityHost.performRangedAttack(this.attackTarget, lvt_5_1_);
                this.rangedAttackTime = Mth.floor((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = Mth.sqrt((float)((float)d0)) / this.attackRadius;
                this.rangedAttackTime = Mth.floor((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }
}

