/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.iceika.EntityCauldronFish;
import divinerpg.registries.EntityRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class EntityBlubbertusk
extends Animal {
    private static final Ingredient FOOD_ITEMS = Ingredient.of((TagKey)ItemTags.FISHES);
    private int energy = 6000;
    private int previousEnergy = 6000;

    public EntityBlubbertusk(EntityType<? extends EntityBlubbertusk> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.DOOR_IRON_CLOSED, -1.0f);
        this.setPathfindingMalus(PathType.DOOR_WOOD_CLOSED, -1.0f);
        this.setPathfindingMalus(PathType.DOOR_OPEN, -1.0f);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.18f, 0.5f, true);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 20);
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public boolean hurt(DamageSource source, float f) {
        if (f > 0.1f) {
            this.energy += 500;
        }
        return super.hurt(source, f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(1, (Goal)new BlubbertuskPanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)FOOD_ITEMS, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new BlubbertuskStrollGoal(this, 1.0, 10));
        this.goalSelector.addGoal(5, (Goal)new BlubbertuskJumpGoal(this, 10));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityCauldronFish.class, true));
    }

    protected PathNavigation createNavigation(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.previousEnergy = this.energy--;
        if (this.isInWater()) {
            if (this.energy < 0) {
                this.energy = 0;
            }
            if (this.previousEnergy > 499 && this.energy < 500) {
                this.setPathfindingMalus(PathType.WATER, -2.0f);
            }
            if (this.getAirSupply() < 200 && this.level().getBlockState(this.blockPosition().above()).isAir()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.5, 0.0));
            }
        } else {
            this.energy += 5;
            if (this.energy > 6000) {
                this.energy = 6000;
            }
            if (this.previousEnergy < 5001 && this.energy > 5000) {
                this.setPathfindingMalus(PathType.WATER, 2.0f);
            }
        }
    }

    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(vec);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public int getMaxAirSupply() {
        return 4000;
    }

    protected int increaseAirSupply(int i) {
        return 4000;
    }

    protected void playSwimSound(float f) {
        super.playSwimSound(f * 1.5f);
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.DOLPHIN_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.DOLPHIN_SPLASH;
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)EntityRegistry.BLUBBERTUSK.get()).create((Level)level);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || source.is(DamageTypes.DROWN);
    }

    public boolean isFood(ItemStack item) {
        return item.is(ItemTags.FISHES);
    }

    public boolean canBeLeashed() {
        return true;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getFluidState(pos).is(FluidTags.WATER) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Energy")) {
            this.energy = tag.getInt("Energy");
            this.previousEnergy = tag.getInt("PreviousEnergy");
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Energy", this.energy);
        tag.putInt("PreviousEnergy", this.previousEnergy);
    }

    static class BlubbertuskPanicGoal
    extends PanicGoal {
        BlubbertuskPanicGoal(PathfinderMob mob, double speedModifier) {
            super(mob, speedModifier);
        }

        public boolean canUse() {
            if (!this.shouldPanic()) {
                return false;
            }
            BlockPos pos = this.lookForWater((BlockGetter)this.mob.level(), (Entity)this.mob, 7);
            if (pos == null) {
                return this.findRandomPosition();
            }
            this.posX = pos.getX();
            this.posY = pos.getY();
            this.posZ = pos.getZ();
            return true;
        }
    }

    static class BlubbertuskStrollGoal
    extends RandomStrollGoal {
        BlubbertuskStrollGoal(EntityBlubbertusk entity, double speedModifier, int interval) {
            super((PathfinderMob)entity, speedModifier, interval);
        }

        public boolean canUse() {
            return (this.mob.isInWater() || ((EntityBlubbertusk)this.mob).energy > 1000) && super.canUse();
        }

        protected Vec3 getPosition() {
            return this.mob.isInWater() && this.mob.getAirSupply() > 140 && ((EntityBlubbertusk)this.mob).energy > 500 ? BehaviorUtils.getRandomSwimmablePos((PathfinderMob)this.mob, (int)10, (int)7) : super.getPosition();
        }
    }

    static class BlubbertuskJumpGoal
    extends JumpGoal {
        static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7};
        final EntityBlubbertusk mob;
        final int interval;
        boolean breached;

        BlubbertuskJumpGoal(EntityBlubbertusk entity, int delay) {
            this.mob = entity;
            this.interval = BlubbertuskJumpGoal.reducedTickDelay((int)delay);
        }

        public boolean canUse() {
            if (this.mob.getRandom().nextInt(this.interval) != 0) {
                return false;
            }
            Direction direction = this.mob.getMotionDirection();
            int stepX = direction.getStepX();
            int stepZ = direction.getStepZ();
            BlockPos blockpos = this.mob.blockPosition();
            for (int step : STEPS_TO_CHECK) {
                if (this.landingIsClear(blockpos, stepX, stepZ, step) && this.surfaceIsClear(blockpos, stepX, stepZ, step)) continue;
                return false;
            }
            return true;
        }

        boolean landingIsClear(BlockPos pos, int stepX, int stepZ, int step) {
            BlockPos blockPos = pos.offset(stepX * step, 0, stepZ * step);
            return this.mob.level().getBlockState(blockPos).blocksMotion();
        }

        boolean surfaceIsClear(BlockPos pos, int stepX, int stepZ, int step) {
            return this.mob.level().getBlockState(pos.offset(stepX * step, 1, stepZ * step)).isAir() && this.mob.level().getBlockState(pos.offset(stepX * step, 2, stepZ * step)).isAir();
        }

        public boolean canContinueToUse() {
            double yMov = this.mob.getDeltaMovement().y;
            return !(yMov * yMov < 0.03 && this.mob.getXRot() != 0.0f && Mth.abs((float)this.mob.getXRot()) < 10.0f && this.mob.isInWater() || this.mob.onGround());
        }

        public boolean isInterruptable() {
            return false;
        }

        public void start() {
            Direction direction = this.mob.getMotionDirection();
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add((double)direction.getStepX() * 0.6, 0.5, (double)direction.getStepZ() * 0.6));
            this.mob.getNavigation().stop();
        }

        public void tick() {
            boolean prevBreach = this.breached;
            if (!prevBreach) {
                this.breached = this.mob.level().getFluidState(this.mob.blockPosition()).is(FluidTags.WATER);
            }
            Vec3 mov = this.mob.getDeltaMovement();
            if (mov.y * mov.y < 0.03 && this.mob.getXRot() != 0.0f) {
                this.mob.setXRot(Mth.rotLerp((float)0.2f, (float)this.mob.getXRot(), (float)0.0f));
            } else if (mov.length() > 5.0E-5) {
                this.mob.setXRot((float)(Mth.atan2((double)(-mov.y), (double)mov.horizontalDistance()) * 57.2957763671875));
            }
        }
    }
}

