/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.entities.projectile.fireball.EntityFractiteShot;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityFractite
extends EntityDivineFlyingMonster
implements RangedAttackMob {
    public EntityFractite(EntityType<? extends EntityFractite> type, Level worldIn) {
        super((EntityType<? extends EntityDivineFlyingMonster>)type, worldIn);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue(), 40, (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue()));
        super.registerGoals();
    }

    public void performRangedAttack(LivingEntity entity, float range) {
        LivingEntity target = this.getTarget();
        if (this.isAlive() && target != null) {
            this.playSound((SoundEvent)SoundRegistry.FRACTITE_ATTACK.get());
            if (!this.level().isClientSide) {
                EntityFractiteShot projectile = new EntityFractiteShot(this.level(), (LivingEntity)this, 0.0, 0.0, 0.0);
                projectile.setPos(new Vec3(this.getX(), this.getEyeY(), this.getZ()));
                projectile.shoot(target.getX() - this.getX() + this.random.nextDouble() - this.random.nextDouble(), target.getEyeY() - this.getEyeY() - this.random.nextDouble() / 2.0, target.getZ() - this.getZ() + this.random.nextDouble() - this.random.nextDouble(), 1.6f, 0.8f);
                this.level().addFreshEntity((Entity)projectile);
            }
        }
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public boolean isMaxGroupSizeReached(int i) {
        return i > 1;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.FRACTITE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.FRACTITE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.FRACTITE_HURT.get();
    }
}

