/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityHastreus
extends EntityDivineMonster {
    private int attackTick;

    public EntityHastreus(EntityType<? extends EntityHastreus> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        if (this.level().getRandom().nextInt(10) == 0) {
            List e = this.level().getEntities((Entity)this, new AABB(-25.0, -16.0, -25.0, 25.0, 16.0, 25.0));
            for (Entity entity : e) {
                if (!(entity instanceof LivingEntity) || entity instanceof EntityHastreus || entity instanceof Player && (((Player)entity).isCreative() || entity.isSpectator()) || !this.isLookingAtMe((LivingEntity)entity)) continue;
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 18, true, false));
            }
        }
        super.tick();
    }

    boolean isLookingAtMe(LivingEntity entity) {
        Vec3 vec3 = entity.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(this.getX() - entity.getX(), this.getEyeY() - entity.getEyeY(), this.getZ() - entity.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 && entity.hasLineOfSight((Entity)this);
    }

    public void addAdditionalSaveData(CompoundTag p_33353_) {
        super.addAdditionalSaveData(p_33353_);
        p_33353_.putInt("AttackTick", this.attackTick);
    }

    public void readAdditionalSaveData(CompoundTag p_33344_) {
        super.readAdditionalSaveData(p_33344_);
        this.attackTick = p_33344_.getInt("AttackTick");
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && this.attackTick > 0) {
            --this.attackTick;
        }
    }

    public void handleEntityEvent(byte p_33335_) {
        if (p_33335_ == 4) {
            this.attackTick = 10;
        }
        super.handleEntityEvent(p_33335_);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public boolean doHurtTarget(Entity p_33328_) {
        this.attackTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(p_33328_);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.HASTREUS.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.HASTREUS_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.HASTREUS_HURT.get();
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    public boolean isMaxGroupSizeReached(int i) {
        return i > 3;
    }
}

