/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.goals.AlertingHurtByTargetGoal;
import divinerpg.entities.goals.ProtectBabyFromPlayerGoal;
import divinerpg.entities.iceika.EntitySabear;
import divinerpg.entities.iceika.EntitySeng;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.TagRegistry;
import divinerpg.util.Utils;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class EntityMamoth
extends Animal
implements NeutralMob {
    public boolean wantsToFly = false;
    public static final Ingredient FOOD = Ingredient.of(TagRegistry.ANIMAL_FOODS_MAMOTH);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    protected Vec3 pathfindPos;
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;

    public EntityMamoth(EntityType<? extends EntityMamoth> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    public BlockPos adjustSpawnLocation(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mut = pos.mutable();
        while (level.getBlockState((BlockPos)mut).is(Blocks.POWDER_SNOW)) {
            mut.move(Direction.UP);
        }
        return mut;
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this, Shapes.create((AABB)this.getBoundingBox().deflate(0.2)));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal(this, (PathfinderMob)this, 2.0){

            protected boolean shouldPanic() {
                return this.mob.getLastHurtByMob() != null && this.mob.isBaby() || this.mob.isOnFire();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AlertingHurtByTargetGoal((PathfinderMob)this));
        this.targetSelector.addGoal(2, (Goal)new ProtectBabyFromPlayerGoal((Mob)this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EntityMamoth)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, 10, true, true, null));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, PolarBear.class, 10, true, true, null));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, EntitySeng.class, 10, true, true, null));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, EntitySabear.class, 10, true, true, null));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.updatePersistentAnger(level2, true);
            if (this.isBaby()) {
                if (this.getLastHurtByMob() != null || this.wantsToFly) {
                    if (this.onGround()) {
                        this.setDeltaMovement(this.getDeltaMovement().multiply(1.1, 1.0, 1.1));
                        if (Math.pow(this.getDeltaMovement().x, 2.0) + Math.pow(this.getDeltaMovement().z, 2.0) > 8.0) {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.5, 0.0));
                        }
                    } else if (!this.isInWater()) {
                        boolean blockedPath;
                        if (!this.isNoGravity()) {
                            this.setNoGravity(true);
                        }
                        if (this.getNavigation().isInProgress()) {
                            this.getNavigation().stop();
                        }
                        boolean bl = blockedPath = this.horizontalCollision || this.verticalCollision;
                        if (!blockedPath) {
                            Vec3 futurePos = this.position().add(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
                            BlockPos pos = new BlockPos((int)futurePos.x, (int)futurePos.y, (int)futurePos.z);
                            BlockState state = this.level().getBlockState(pos);
                            boolean bl2 = blockedPath = state.is(Blocks.LAVA) || !state.getCollisionShape((BlockGetter)this.level(), pos).equals(Shapes.empty());
                        }
                        if (this.pathfindPos == null || blockedPath) {
                            this.pathfindPos = new Vec3(this.getX() + (double)((this.random.nextFloat() - 0.5f) * 14.0f), this.getY() + (double)((this.random.nextFloat() - 0.6f) * 14.0f), this.getZ() + (double)((this.random.nextFloat() - 0.5f) * 14.0f));
                        }
                        double speed = this.getAttributeValue(Attributes.FLYING_SPEED);
                        this.setDeltaMovement(this.getDeltaMovement().x + (this.pathfindPos.x - this.getX()) / 64.0 * speed, this.getDeltaMovement().y + (this.pathfindPos.y - this.getY()) / 64.0 * speed, this.getDeltaMovement().z + (this.pathfindPos.z - this.getZ()) / 64.0 * speed);
                        double distanceX = this.pathfindPos.x - this.getX();
                        double distanceY = this.pathfindPos.y - this.getY();
                        double distanceZ = this.pathfindPos.z - this.getZ();
                        this.yHeadRot = Utils.rotlerp(this.getYRot(), (float)(Mth.atan2((double)distanceZ, (double)distanceX) * 180.0 / Math.PI) - 90.0f, 90.0f);
                        this.xRotO = Utils.rotlerp(this.getXRot(), (float)(-(Mth.atan2((double)distanceY, (double)Math.sqrt(distanceX * distanceX + distanceZ * distanceZ)) * 180.0 / Math.PI)), 20.0f);
                        if (Math.sqrt(this.distanceToSqr(this.pathfindPos)) < 2.0) {
                            this.pathfindPos = null;
                        }
                        this.fallDistance = 0.0f;
                    }
                } else {
                    if (this.isNoGravity()) {
                        this.setNoGravity(false);
                    }
                    if (this.getDeltaMovement().y < 0.0) {
                        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
                        this.fallDistance = 0.0f;
                    }
                }
                if (this.random.nextInt(100) == 0) {
                    this.wantsToFly = !this.wantsToFly;
                    this.setLastHurtByMob(null);
                }
            } else if (this.isNoGravity()) {
                this.setNoGravity(false);
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        Level level;
        DamageSource source = this.damageSources().mobAttack((LivingEntity)this);
        boolean hurt = entity.hurt(source, (float)((int)this.getAttributeValue(Attributes.ATTACK_DAMAGE)));
        if (hurt && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffects((ServerLevel)level2, (Entity)entity, (DamageSource)source);
        }
        return hurt;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType type, SpawnGroupData data) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.finalizeSpawn(level, instance, type, data);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)EntityRegistry.MAMOTH.get()).create((Level)level);
    }

    public boolean isFood(ItemStack stack) {
        return FOOD.test(stack);
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int i) {
        this.remainingPersistentAngerTime = i;
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.persistentAngerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readPersistentAngerSaveData(this.level(), tag);
        if (tag.contains("wants_to_fly")) {
            this.wantsToFly = tag.getBoolean("wants_to_fly");
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addPersistentAngerSaveData(tag);
        if (this.isBaby()) {
            tag.putBoolean("wants_to_fly", this.wantsToFly);
        }
    }
}

