/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.base.EntityDivineMerchant;
import divinerpg.entities.base.FactionEntity;
import divinerpg.entities.goals.AvoidFactionGoal;
import divinerpg.registries.RecipeRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EntityWorkshopTinkerer
extends EntityDivineMerchant
implements FactionEntity {
    public EntityWorkshopTinkerer(EntityType<? extends EntityWorkshopTinkerer> type, Level worldIn) {
        super(type, worldIn, "workshop_tinkerer");
    }

    @Override
    public FactionEntity.Faction getFaction() {
        return FactionEntity.Faction.ICEIKA_MERCHANT;
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if ((Integer)this.getFaction().reputation.get((Entity)player) > 5) {
            return super.mobInteract(player, hand);
        }
        this.playSound(SoundEvents.VILLAGER_NO);
        return InteractionResult.FAIL;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidFactionGoal((PathfinderMob)this, this.getFaction(), 15.0f, 0.5, 0.5));
    }

    @Override
    public String[] getChatMessages() {
        return new String[]{"message.merchant.burr", "message.merchant.ho", "message.merchant.in", "message.merchant.out"};
    }

    protected void updateTrades() {
        this.addOffersFromItemListings(this.getOffers(), RecipeRegistry.Trades.WORKSHOP_TINKERER.get(this.level(), this.getRandom()), 5);
    }
}

