/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika.groglin;

import divinerpg.entities.iceika.groglin.Groglin;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.RecipeRegistry;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GroglinSharlatan
extends Groglin
implements RangedAttackMob {
    public GroglinSharlatan(EntityType<? extends GroglinSharlatan> type, Level worldIn) {
        super(type, worldIn);
        if (!worldIn.isClientSide()) {
            this.setData((Supplier)AttachmentRegistry.IMPORTANT.attachment, true);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ItemRegistry.serenade_of_ice.get()));
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new RangedAttackGoal((RangedAttackMob)this, this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue(), 10, (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue()));
    }

    public void performRangedAttack(LivingEntity e, float f) {
        LivingEntity target = this.getTarget();
        if (this.isAlive() && target != null) {
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 25, 1, false, true, true));
            target.setTicksFrozen(target.getTicksFrozen() + 10);
            if (this.getRandom().nextBoolean()) {
                target.hurt(this.damageSources().indirectMagic((Entity)this, (Entity)this), 1.0f);
            }
        }
    }

    protected void updateTrades() {
        this.addOffersFromItemListings(this.getOffers(), RecipeRegistry.Trades.GROGLIN_SHARLATAN.get(this.level(), this.getRandom()), 3);
    }
}

