/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.effect.mob.EnderAttachmentEffect;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public abstract class DivineArrow
extends AbstractArrow {
    public float powerMultiplier = 1.0f;

    public DivineArrow(EntityType<? extends DivineArrow> entityType, Level level) {
        super(entityType, level);
    }

    public DivineArrow(EntityType<? extends AbstractArrow> type, Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(type, owner, level, pickupItemStack, firedFromWeapon);
    }

    public DivineArrow(EntityType<? extends AbstractArrow> type, Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, level, pickupItemStack, firedFromWeapon);
    }

    public float getArrowPower() {
        return 2.0f;
    }

    protected void onHitEntity(EntityHitResult result) {
        this.setBaseDamage(this.getArrowPower() * this.powerMultiplier);
        super.onHitEntity(result);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("power_m", this.powerMultiplier);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.powerMultiplier = compound.getFloat("power_m");
    }

    public void addEffect(MobEffectInstance effectInstance) {
        Iterable contents = this.getPotionContents().getAllEffects();
        for (MobEffectInstance c : contents) {
            if (!c.is(effectInstance.getEffect())) continue;
            return;
        }
        this.setPotionContents(this.getPotionContents().withEffectAdded(effectInstance));
    }

    protected PotionContents getPotionContents() {
        return (PotionContents)this.getPickupItemStackOrigin().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    private void setPotionContents(PotionContents potionContents) {
        this.getPickupItemStackOrigin().set(DataComponents.POTION_CONTENTS, (Object)potionContents);
    }

    protected void doPostHurtEffects(LivingEntity living) {
        super.doPostHurtEffects(living);
        Entity entity = this.getEffectSource();
        PotionContents potioncontents = this.getPotionContents();
        if (potioncontents.potion().isPresent()) {
            for (MobEffectInstance mobeffectinstance : ((Potion)((Holder)potioncontents.potion().get()).value()).getEffects()) {
                if (((MobEffect)mobeffectinstance.getEffect().value()).isInstantenous()) {
                    ((MobEffect)mobeffectinstance.getEffect().value()).applyInstantenousEffect(this.getOwner(), (Entity)this, living, mobeffectinstance.getAmplifier(), 1.0);
                    continue;
                }
                living.addEffect(new MobEffectInstance(mobeffectinstance.getEffect(), Math.max(mobeffectinstance.mapDuration(p_268168_ -> p_268168_ / 8), 1), mobeffectinstance.getAmplifier(), mobeffectinstance.isAmbient(), mobeffectinstance.isVisible()), entity);
            }
        }
        for (MobEffectInstance mobeffectinstance1 : potioncontents.customEffects()) {
            if (((MobEffect)mobeffectinstance1.getEffect().value()).isInstantenous()) {
                ((MobEffect)mobeffectinstance1.getEffect().value()).applyInstantenousEffect(this.getOwner(), (Entity)this, living, mobeffectinstance1.getAmplifier(), 1.0);
                continue;
            }
            living.addEffect(mobeffectinstance1, entity);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            Object object;
            PotionContents potionContents = this.getPotionContents();
            if (potionContents.potion().isPresent()) {
                for (MobEffectInstance instance : ((Potion)((Holder)potionContents.potion().get()).value()).getEffects()) {
                    object = instance.getEffect().value();
                    if (!(object instanceof EnderAttachmentEffect)) continue;
                    EnderAttachmentEffect e = (EnderAttachmentEffect)((Object)object);
                    e.hitBlock(this.getOwner(), (Entity)this);
                }
            }
            for (MobEffectInstance instance : potionContents.customEffects()) {
                object = instance.getEffect().value();
                if (!(object instanceof EnderAttachmentEffect)) continue;
                EnderAttachmentEffect e = (EnderAttachmentEffect)((Object)object);
                e.hitBlock(this.getOwner(), (Entity)this);
            }
        }
    }
}

