/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class DivineFireball
extends Fireball {
    public byte explosionPower;

    public DivineFireball(EntityType<? extends DivineFireball> type, Level world) {
        super(type, world);
        this.explosionPower = 0;
    }

    public DivineFireball(EntityType<? extends DivineFireball> type, Level world, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(type, shooter, new Vec3(accelX, accelY, accelZ), world);
        this.setOwner((Entity)shooter);
        this.explosionPower = 0;
    }

    public DivineFireball(EntityType<? extends DivineFireball> type, Level world, LivingEntity shooter, double accelX, double accelY, double accelZ, byte explosionPower) {
        super(type, shooter, new Vec3(accelX, accelY, accelZ), world);
        this.setOwner((Entity)shooter);
        this.explosionPower = explosionPower;
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    public ProjectileDeflection deflection(Projectile projectile) {
        return ProjectileDeflection.NONE;
    }

    protected void onHit(HitResult result) {
        if (this.tickCount > 1) {
            super.onHit(result);
            if (!this.level().isClientSide() && this.explosionPower > 0) {
                boolean flag = EventHooks.canEntityGrief((Level)this.level(), (Entity)this.getOwner());
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)this.explosionPower, flag, Level.ExplosionInteraction.MOB);
                this.discard();
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.tickCount > 1) {
            super.onHitEntity(result);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                Entity entity = result.getEntity();
                Entity owner = this.getOwner();
                DamageSource source = this.damageSources().fireball((Fireball)this, owner);
                entity.hurt(source, 6.0f);
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)level2, (Entity)owner, (DamageSource)source);
                }
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("ExplosionPower", this.explosionPower);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("ExplosionPower", 99)) {
            this.explosionPower = tag.getByte("ExplosionPower");
        }
    }
}

