/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.items.ranged.ItemThrowable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class DivineThrownItem
extends ThrowableItemProjectile {
    public boolean canPickup = true;

    public DivineThrownItem(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected Item getDefaultItem() {
        return Items.EGG;
    }

    public void drop() {
        ItemStack item = this.getItem();
        if (this.canPickup && !item.isEmpty()) {
            this.spawnAtLocation(this.getItem(), 0.1f);
        }
        this.discard();
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 200) {
            this.drop();
        }
    }

    public DamageSource getDamageSource(EntityHitResult result) {
        return this.damageSources().thrown((Entity)this, this.getOwner());
    }

    protected void doPostHurtEffects(LivingEntity living) {
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level;
        float f;
        Item item;
        Entity entity = result.getEntity();
        ItemStack item2 = this.getItem();
        float f2 = (float)this.getDeltaMovement().length();
        if (item2.isEmpty() || !((item = item2.getItem()) instanceof ItemThrowable)) {
            f = 1.0f;
        } else {
            ItemThrowable t = (ItemThrowable)item;
            f = t.damage;
        }
        float d0 = f;
        Entity owner = this.getOwner();
        DamageSource damageSource = this.getDamageSource(result);
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)s, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damageSource, (float)d0);
        }
        int j = Mth.ceil((float)Mth.clamp((float)(f2 * d0), (float)0.0f, (float)2.1474836E9f));
        int i = entity.getRemainingFireTicks();
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            livingOwner.setLastHurtMob(entity);
        }
        if (this.isOnFire()) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damageSource, (float)j)) {
            if (!(entity instanceof EnderMan)) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    Level level2 = this.level();
                    if (level2 instanceof ServerLevel) {
                        ServerLevel s1 = (ServerLevel)level2;
                        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)s1, (Entity)livingEntity, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                    }
                    this.doPostHurtEffects(livingEntity);
                }
                this.canPickup = false;
            }
            this.drop();
        } else {
            entity.setRemainingFireTicks(i);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < -6.0) {
                this.drop();
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.drop();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("pickup", this.canPickup);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.canPickup = compound.getBoolean("pickup");
    }
}

