/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.arrows;

import divinerpg.entities.projectile.DivineArrow;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class EnderArrow
extends DivineArrow {
    public EnderArrow(EntityType<? extends DivineArrow> entityType, Level level) {
        super(entityType, level);
    }

    public EnderArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.ENDER_ARROW.get()), level, owner, pickupItemStack, firedFromWeapon);
    }

    public EnderArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.ENDER_ARROW.get()), level, x, y, z, pickupItemStack, firedFromWeapon);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ItemRegistry.ender_arrow.get());
    }

    @Override
    public float getArrowPower() {
        return 4.0f;
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        LivingEntity e;
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && (e = (LivingEntity)entity).isSensitiveToWater()) {
            Level level;
            Entity entity2 = result.getEntity();
            float f = (float)this.getDeltaMovement().length();
            float d0 = this.getArrowPower() * this.powerMultiplier;
            Entity owner = this.getOwner();
            DamageSource damagesource = this.damageSources().indirectMagic((Entity)this, owner);
            if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
                ServerLevel s = (ServerLevel)level;
                d0 = EnchantmentHelper.modifyDamage((ServerLevel)s, (ItemStack)this.getWeaponItem(), (Entity)entity2, (DamageSource)damagesource, (float)d0);
            }
            int j = Mth.ceil((double)Mth.clamp((double)((double)f * (double)d0), (double)0.0, (double)2.147483647E9));
            int i = entity2.getRemainingFireTicks();
            if (this.isCritArrow()) {
                j = (int)Math.min((long)this.random.nextInt(j / 2 + 2) + (long)j, Integer.MAX_VALUE);
            }
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                livingOwner.setLastHurtMob(entity2);
            }
            if (this.isOnFire()) {
                entity2.igniteForSeconds(5.0f);
            }
            if (entity2.hurt(damagesource, (float)j)) {
                if (entity2 instanceof LivingEntity) {
                    Level level2;
                    LivingEntity livingentity = (LivingEntity)entity2;
                    if (!this.level().isClientSide) {
                        livingentity.setArrowCount(livingentity.getArrowCount() + 1);
                    }
                    if ((level2 = this.level()) instanceof ServerLevel) {
                        ServerLevel s1 = (ServerLevel)level2;
                        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)s1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                    }
                    this.doPostHurtEffects(livingentity);
                    if (!this.level().isClientSide && owner instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)owner;
                        if (!entity2.isAlive() && this.shotFromCrossbow()) {
                            CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverplayer, List.of(entity2));
                        }
                    }
                }
                this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                this.discard();
            } else {
                entity2.setRemainingFireTicks(i);
                this.deflect(ProjectileDeflection.REVERSE, entity2, this.getOwner(), false);
                this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
                if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < -6.0) {
                    if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                        this.spawnAtLocation(this.getPickupItem(), 0.1f);
                    }
                    this.discard();
                }
            }
        } else {
            super.onHitEntity(result);
        }
    }
}

