/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.bullet;

import java.util.List;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityHeatSeekingProjectile
extends ThrowableProjectile {
    private LivingEntity target = null;
    private boolean onlyPlayers = false;

    public EntityHeatSeekingProjectile(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
    }

    public EntityHeatSeekingProjectile(EntityType<? extends ThrowableProjectile> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public void setPlayersOnly() {
        this.onlyPlayers = true;
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        List mobs = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(30.0, 30.0, 30.0));
        boolean findNewTarget = this.target == null || this.target.isDeadOrDying();
        for (LivingEntity e : mobs) {
            if (e == this.getOwner() || this.onlyPlayers && !(e instanceof Player)) continue;
            float targetDist = this.target == null ? 0.0f : this.distanceTo((Entity)this.target);
            float compareDist = this.distanceTo((Entity)e);
            if (!findNewTarget || this.target != null && !(compareDist < targetDist)) continue;
            this.target = e;
        }
        if (this.target != null) {
            Vec3 dir = new Vec3(this.target.xo - this.xo, this.target.yo + (double)this.target.getEyeHeight() - this.yo, this.target.zo - this.zo).normalize();
            this.setDeltaMovement(dir.x / 1.25, dir.y / 1.25, dir.z / 1.25);
        }
        if (this.tickCount > 50) {
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }
}

