/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.bullet;

import divinerpg.entities.projectile.magic.DivineParticleProjectile;
import divinerpg.registries.DamageRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ParticleRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class GeneralsShot
extends DivineParticleProjectile {
    public boolean shouldSpray = true;

    public GeneralsShot(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level, 4.3f, () -> ParticleRegistry.WILDWOOD_PORTAL.value());
    }

    @Override
    public DamageSource getDamageSource(EntityHitResult result) {
        return this.damageSources().source(DamageRegistry.ARCANA.getKey(), (Entity)this);
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        this.hitBlockNoDiscard(result);
        if (this.shouldSpray) {
            EntityType type = (EntityType)EntityRegistry.GENERALS_SHOT.get();
            Vec3 pos = this.position().add(0.0, 0.01, 0.0);
            GeneralsShot shot = (GeneralsShot)type.create(this.level());
            shot.shouldSpray = false;
            shot.setPos(pos);
            shot.shoot(0.0, 1.0, 0.0, 0.5f, 1.0f);
            this.level().addFreshEntity((Entity)shot);
            shot = (GeneralsShot)type.create(this.level());
            shot.shouldSpray = false;
            shot.setPos(pos);
            shot.shoot(1.0, 1.0, 0.0, 0.5f, 1.0f);
            this.level().addFreshEntity((Entity)shot);
            shot = (GeneralsShot)type.create(this.level());
            shot.shouldSpray = false;
            shot.setPos(pos);
            shot.shoot(-1.0, 1.0, 0.0, 0.5f, 1.0f);
            this.level().addFreshEntity((Entity)shot);
            shot = (GeneralsShot)type.create(this.level());
            shot.shouldSpray = false;
            shot.setPos(pos);
            shot.shoot(0.0, 1.0, 1.0, 0.5f, 1.0f);
            this.level().addFreshEntity((Entity)shot);
            shot = (GeneralsShot)type.create(this.level());
            shot.shouldSpray = false;
            shot.setPos(pos);
            shot.shoot(0.0, 1.0, -1.0, 0.5f, 1.0f);
            this.level().addFreshEntity((Entity)shot);
        }
        this.discard();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("spray", this.shouldSpray);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.shouldSpray = compound.getBoolean("spray");
    }
}

