/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.magic;

import divinerpg.entities.projectile.magic.DivineParticleProjectile;
import divinerpg.registries.DamageRegistry;
import divinerpg.registries.ParticleRegistry;
import java.util.function.Supplier;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class EntityLadyLunaSparkler
extends DivineParticleProjectile {
    public EntityLadyLunaSparkler(EntityType<? extends DivineParticleProjectile> type, Level world) {
        super((EntityType<? extends ThrowableProjectile>)type, world, 12.0f, (Supplier<SimpleParticleType>)ParticleRegistry.APALACHIA_PORTAL);
    }

    public boolean isNoGravity() {
        return true;
    }

    @Override
    public void tick() {
        LivingEntity entity;
        Entity entity2;
        super.tick();
        if (this.getOwner() != null && (entity2 = this.getOwner()) instanceof LivingEntity && (entity = (LivingEntity)entity2).getLastHurtByMob() != null) {
            double tx = entity.getLastHurtByMob().xo - entity.xo;
            double ty = entity.getLastHurtByMob().getBoundingBox().minY - entity.yo;
            double tz = entity.getLastHurtByMob().zo - entity.zo;
            if (!this.level().isClientSide && this.tickCount > 30) {
                this.shoot(tx, ty, tz, 0.5f, 0.0f);
            }
        }
        if (!this.level().isClientSide && this.tickCount > 80) {
            this.discard();
        }
    }

    @Override
    public DamageSource getDamageSource(EntityHitResult result) {
        return this.level().damageSources().source(DamageRegistry.ARCANA.getKey());
    }
}

