/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.end;

import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.entities.projectile.fireball.EntityEnderTripletsFireball;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityEnderTriplets
extends EntityDivineFlyingMonster
implements RangedAttackMob {
    public EntityEnderTriplets(EntityType<? extends EntityEnderTriplets> type, Level worldIn) {
        super(type, worldIn, 18.0f);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public boolean isMaxGroupSizeReached(int i) {
        return i > 1;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 64.0f));
        super.registerGoals();
    }

    public void performRangedAttack(LivingEntity entity, float range) {
        if (this.isAlive() && this.getTarget() != null) {
            Vec3 vector3d = this.getViewVector(1.0f);
            double d0 = this.getTarget().getX() - (this.getX() + vector3d.x * 4.0);
            double d1 = this.getTarget().getY(0.5) - (0.5 + this.getY(0.5));
            double d2 = this.getTarget().getZ() - (this.getZ() + vector3d.z * 4.0);
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            EntityEnderTripletsFireball shot = new EntityEnderTripletsFireball(this.level(), (LivingEntity)this, d0, d1, d2);
            shot.shoot(d0, d1 + d3 * 0.2, d2, 3.3f, 0.2f);
            if (!this.level().isClientSide) {
                this.level().addFreshEntity((Entity)shot);
            }
            this.playSound(SoundEvents.FOX_TELEPORT);
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PARROT_IMITATE_GHAST;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.GHAST_SCREAM;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GHAST_DEATH;
    }
}

