/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.nether;

import divinerpg.entities.base.EntityDivineFireballMob;
import divinerpg.entities.projectile.fireball.EntityScorcherShot;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;

public class EntityScorcher
extends EntityDivineFireballMob {
    public EntityScorcher(EntityType<? extends EntityScorcher> type, Level world) {
        super((EntityType<? extends EntityDivineFireballMob>)type, world);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.xpReward = 10;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue(), 8, (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue()));
        super.registerGoals();
    }

    @Override
    protected Fireball getProjectile() {
        return new EntityScorcherShot(this.level(), (LivingEntity)this, 0.0, 0.0, 0.0);
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide) {
            if (this.random.nextInt(24) == 0 && !this.isSilent()) {
                this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, SoundEvents.BLAZE_BURN, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public boolean isMaxGroupSizeReached(int i) {
        return i > 1;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.SCORCHER.get();
    }

    @Override
    protected SoundEvent getShootSound() {
        return SoundEvents.BLAZE_SHOOT;
    }
}

