/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.nether;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.DataComponentRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityWildfire
extends EntityDivineMonster
implements RangedAttackMob {
    public EntityWildfire(EntityType<? extends EntityWildfire> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new LookingRangedBowAttackGoal<EntityWildfire>(this));
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.inferno_bow.get());
        stack.enchant(this.registryAccess().holderOrThrow(Enchantments.VANISHING_CURSE), 1);
        this.setItemSlot(EquipmentSlot.MAINHAND, stack);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data) {
        RandomSource random = level.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(level, random, difficulty);
        return data;
    }

    public void tick() {
        super.tick();
        this.getItemBySlot(EquipmentSlot.MAINHAND).inventoryTick(this.level(), (Entity)this, 0, true);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        float f;
        if (this.isAlive() && this.getTarget() != null && (f = BowItem.getPowerForTime((int)((int)(72000.0f * distanceFactor)))) >= 0.1f) {
            ItemStack stack = this.getItemBySlot(EquipmentSlot.MAINHAND);
            stack.set(DataComponentRegistry.weaponAbility, (Object)9);
            stack.set(DataComponentRegistry.weaponPower, (Object)Float.valueOf(f));
        }
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return 0.0f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.WILDFIRE.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.WILDFIRE_HURT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.WILDFIRE_HURT.get();
    }

    public static class LookingRangedBowAttackGoal<T extends Mob>
    extends RangedBowAttackGoal<T> {
        protected final TargetingConditions lookAtContext;
        protected T mob;

        public LookingRangedBowAttackGoal(T mob) {
            super(mob, mob.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue(), 40, 32.0f);
            this.mob = mob;
            this.lookAtContext = TargetingConditions.forNonCombat().range(32.0).selector(e -> EntitySelector.notRiding((Entity)mob).test(e));
        }

        public void tick() {
            super.tick();
            LivingEntity target = this.mob.getTarget();
            if (target != null) {
                this.mob.getLookControl().setLookAt((Entity)target);
            }
        }
    }
}

