/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vethea;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EntityDreamwrecker
extends EntityDivineMonster {
    public EntityDreamwrecker(EntityType<? extends EntityDreamwrecker> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        LivingEntity attackTarget;
        super.tick();
        Player player = this.level().getNearestPlayer((Entity)this, 64.0);
        if (player != null && !player.isCreative() && player.distanceTo((Entity)this) < 20.0f) {
            this.setTarget((LivingEntity)player);
        }
        if ((attackTarget = this.getTarget()) instanceof Player && !((Player)attackTarget).isCreative() && attackTarget.isAlive() && this.hasLineOfSight((Entity)attackTarget)) {
            double distanceToTarget = this.distanceToSqr((Entity)attackTarget);
            if (distanceToTarget < 100.0 && attackTarget.getY() - this.getY() <= 10.0) {
                attackTarget.setDeltaMovement(Math.signum(this.xo - attackTarget.xo) * 0.029, attackTarget.getDeltaMovement().y, Math.signum(this.zo - attackTarget.zo) * 0.029);
            }
        } else {
            this.setTarget(null);
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.DREAMWRECKER.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.DREAMWRECKER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.DREAMWRECKER_HURT.get();
    }
}

